/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.webservice.test;

import org.alfresco.webservice.action.Action;
import org.alfresco.webservice.action.ActionExecutionResult;
import org.alfresco.webservice.action.ActionItemDefinition;
import org.alfresco.webservice.action.ActionItemDefinitionType;
import org.alfresco.webservice.action.ActionServiceSoapBindingStub;
import org.alfresco.webservice.action.ParameterDefinition;
import org.alfresco.webservice.action.Rule;
import org.alfresco.webservice.action.RuleType;
import org.alfresco.webservice.test.BaseWebServiceSystemTest;
import org.alfresco.webservice.types.NamedValue;
import org.alfresco.webservice.types.Node;
import org.alfresco.webservice.types.Predicate;
import org.alfresco.webservice.types.Reference;
import org.alfresco.webservice.util.Constants;
import org.alfresco.webservice.util.WebServiceFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionServiceSystemTest
extends BaseWebServiceSystemTest {
    private static Log logger = LogFactory.getLog(ActionServiceSystemTest.class);
    private ActionServiceSoapBindingStub actionService = WebServiceFactory.getActionService();

    public void testGetActionDefinitions() throws Exception {
        ActionItemDefinition[] definitions = this.actionService.getActionDefinitions();
        ActionServiceSystemTest.assertNotNull((Object)definitions);
        ActionServiceSystemTest.assertTrue((definitions.length > 0 ? 1 : 0) != 0);
        if (logger.isDebugEnabled()) {
            System.out.println("Action definitions:");
            for (ActionItemDefinition definition : definitions) {
                System.out.println(definition.getName() + " - " + definition.getTitle());
            }
            System.out.println("");
        }
    }

    public void testGetConditionDefinitions() throws Exception {
        ActionItemDefinition[] definitions = this.actionService.getConditionDefinitions();
        ActionServiceSystemTest.assertNotNull((Object)definitions);
        ActionServiceSystemTest.assertTrue((definitions.length > 0 ? 1 : 0) != 0);
        if (logger.isDebugEnabled()) {
            System.out.println("Condition definitions:");
            for (ActionItemDefinition definition : definitions) {
                System.out.println(definition.getName() + " - " + definition.getTitle());
            }
            System.out.println("");
        }
    }

    public void testGetActionItemDefinition() throws Exception {
        ActionItemDefinition actionDefinition = this.actionService.getActionItemDefinition("add-features", ActionItemDefinitionType.action);
        ActionServiceSystemTest.assertNotNull((Object)actionDefinition);
        ActionServiceSystemTest.assertEquals((String)"add-features", (String)actionDefinition.getName());
        ActionServiceSystemTest.assertNotNull((Object)actionDefinition.getTitle());
        ActionServiceSystemTest.assertNotNull((Object)actionDefinition.getDescription());
        ActionServiceSystemTest.assertEquals((Object)ActionItemDefinitionType.action, (Object)actionDefinition.getType());
        ActionServiceSystemTest.assertTrue((boolean)actionDefinition.isAdHocPropertiesAllowed());
        ActionServiceSystemTest.assertNotNull((Object)actionDefinition.getParameterDefinition());
        ActionServiceSystemTest.assertTrue((actionDefinition.getParameterDefinition().length == 1 ? 1 : 0) != 0);
        ParameterDefinition param = actionDefinition.getParameterDefinition()[0];
        ActionServiceSystemTest.assertEquals((String)"aspect-name", (String)param.getName());
        ActionServiceSystemTest.assertTrue((boolean)param.isIsMandatory());
        ActionServiceSystemTest.assertEquals((String)"{http://www.alfresco.org/model/dictionary/1.0}qname", (String)param.getType());
        ActionItemDefinition conditionDefintion = this.actionService.getActionItemDefinition("no-condition", ActionItemDefinitionType.condition);
        ActionServiceSystemTest.assertNotNull((Object)conditionDefintion);
        ActionServiceSystemTest.assertEquals((String)"no-condition", (String)conditionDefintion.getName());
        ActionServiceSystemTest.assertNotNull((Object)conditionDefintion.getTitle());
        ActionServiceSystemTest.assertNotNull((Object)conditionDefintion.getDescription());
        ActionServiceSystemTest.assertEquals((Object)ActionItemDefinitionType.condition, (Object)conditionDefintion.getType());
        ActionServiceSystemTest.assertFalse((boolean)conditionDefintion.isAdHocPropertiesAllowed());
        ActionServiceSystemTest.assertNull((Object)conditionDefintion.getParameterDefinition());
        ActionItemDefinition bad = this.actionService.getActionItemDefinition("badName", ActionItemDefinitionType.condition);
        ActionServiceSystemTest.assertNull((Object)bad);
    }

    public void testGetRuleTypes() throws Exception {
        RuleType[] ruleTypes = this.actionService.getRuleTypes();
        ActionServiceSystemTest.assertNotNull((Object)ruleTypes);
        ActionServiceSystemTest.assertTrue((ruleTypes.length > 0 ? 1 : 0) != 0);
        if (logger.isDebugEnabled()) {
            System.out.println("Rule types:");
            for (RuleType type : ruleTypes) {
                System.out.println(type.getName() + " - " + type.getDisplayLabel());
            }
        }
        RuleType ruleType = this.actionService.getRuleType("inbound");
        ActionServiceSystemTest.assertNotNull((Object)ruleType);
        ActionServiceSystemTest.assertEquals((String)"inbound", (String)ruleType.getName());
        ActionServiceSystemTest.assertNotNull((Object)ruleType.getDisplayLabel());
        RuleType badRuleType = this.actionService.getRuleType("basRuleName");
        ActionServiceSystemTest.assertNull((Object)badRuleType);
    }

    public void testActionPeristance() throws Exception {
        Action[] actions1 = this.actionService.getActions(BaseWebServiceSystemTest.contentReference, null);
        ActionServiceSystemTest.assertNull((Object)actions1);
        NamedValue[] parameters = new NamedValue[]{new NamedValue("aspect-name", false, Constants.ASPECT_VERSIONABLE, null)};
        Action newAction1 = new Action();
        newAction1.setActionName("add-features");
        newAction1.setTitle("Add the versionable aspect to the node.");
        newAction1.setDescription("This will add the verisonable aspect to the node and thus create a version history.");
        newAction1.setParameters(parameters);
        Action[] saveResults1 = this.actionService.saveActions(BaseWebServiceSystemTest.contentReference, new Action[]{newAction1});
        ActionServiceSystemTest.assertNotNull((Object)saveResults1);
        ActionServiceSystemTest.assertEquals((int)1, (int)saveResults1.length);
        Action savedAction1 = saveResults1[0];
        ActionServiceSystemTest.assertNotNull((Object)savedAction1);
        ActionServiceSystemTest.assertNotNull((Object)savedAction1.getId());
        ActionServiceSystemTest.assertEquals((String)"add-features", (String)savedAction1.getActionName());
        ActionServiceSystemTest.assertEquals((String)"Add the versionable aspect to the node.", (String)savedAction1.getTitle());
        ActionServiceSystemTest.assertEquals((String)"This will add the verisonable aspect to the node and thus create a version history.", (String)savedAction1.getDescription());
        savedAction1.setTitle("The title has been updated");
        Action[] saveResults2 = this.actionService.saveActions(BaseWebServiceSystemTest.contentReference, new Action[]{savedAction1});
        ActionServiceSystemTest.assertNotNull((Object)saveResults2);
        ActionServiceSystemTest.assertEquals((int)1, (int)saveResults2.length);
        Action savedAction2 = saveResults2[0];
        ActionServiceSystemTest.assertNotNull((Object)savedAction2);
        ActionServiceSystemTest.assertEquals((String)savedAction2.getId(), (String)savedAction2.getId());
        ActionServiceSystemTest.assertEquals((String)"add-features", (String)savedAction2.getActionName());
        ActionServiceSystemTest.assertEquals((String)"The title has been updated", (String)savedAction2.getTitle());
        ActionServiceSystemTest.assertEquals((String)"This will add the verisonable aspect to the node and thus create a version history.", (String)savedAction2.getDescription());
        this.actionService.removeActions(BaseWebServiceSystemTest.contentReference, null);
        Action[] actions3 = this.actionService.getActions(BaseWebServiceSystemTest.contentReference, null);
        ActionServiceSystemTest.assertNull((Object)actions3);
    }

    public void testActionExecution() throws Exception {
        Predicate predicate = new Predicate(new Reference[]{BaseWebServiceSystemTest.contentReference}, BaseWebServiceSystemTest.store, null);
        Node node1 = this.repositoryService.get(predicate)[0];
        for (String aspect : node1.getAspects()) {
            if (!Constants.ASPECT_VERSIONABLE.equals(aspect)) continue;
            ActionServiceSystemTest.fail((String)"The content node already has the versionable aspect applied");
        }
        NamedValue[] parameters = new NamedValue[]{new NamedValue("aspect-name", false, Constants.ASPECT_VERSIONABLE, null)};
        Action newAction1 = new Action();
        newAction1.setActionName("add-features");
        newAction1.setTitle("Add the versionable aspect to the node.");
        newAction1.setDescription("This will add the verisonable aspect to the node and thus create a version history.");
        newAction1.setParameters(parameters);
        ActionExecutionResult[] results = this.actionService.executeActions(predicate, new Action[]{newAction1});
        ActionServiceSystemTest.assertNotNull((Object)results);
        ActionServiceSystemTest.assertEquals((int)1, (int)results.length);
        ActionExecutionResult result = results[0];
        ActionServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)result.getReference().getUuid());
        ActionServiceSystemTest.assertNotNull((Object)result.getActions());
        ActionServiceSystemTest.assertEquals((int)1, (int)result.getActions().length);
        Action resultAction = result.getActions()[0];
        ActionServiceSystemTest.assertEquals((String)"add-features", (String)resultAction.getActionName());
        Node node2 = this.repositoryService.get(predicate)[0];
        boolean bFail = true;
        for (String aspect : node2.getAspects()) {
            if (!Constants.ASPECT_VERSIONABLE.equals(aspect)) continue;
            bFail = false;
        }
        if (bFail) {
            ActionServiceSystemTest.fail((String)"The action was executed but the versionable aspect has not been applied to the content reference");
        }
    }

    public void testRulePersistance() throws Exception {
        Rule[] rules1 = this.actionService.getRules(BaseWebServiceSystemTest.contentReference, null);
        ActionServiceSystemTest.assertNull((Object)rules1);
        NamedValue[] parameters = new NamedValue[]{new NamedValue("aspect-name", false, Constants.ASPECT_CLASSIFIABLE, null)};
        Action newAction = new Action();
        newAction.setActionName("add-features");
        newAction.setParameters(parameters);
        Rule newRule = new Rule();
        newRule.setRuleTypes(new String[]{"incomming"});
        newRule.setTitle("This rule adds the classificable aspect");
        newRule.setAction(newAction);
        Rule[] saveResults1 = this.actionService.saveRules(BaseWebServiceSystemTest.contentReference, new Rule[]{newRule});
        ActionServiceSystemTest.assertNotNull((Object)saveResults1);
        ActionServiceSystemTest.assertEquals((int)1, (int)saveResults1.length);
        Rule savedRule1 = saveResults1[0];
        ActionServiceSystemTest.assertNotNull((Object)savedRule1);
        ActionServiceSystemTest.assertNotNull((Object)savedRule1.getRuleReference());
        ActionServiceSystemTest.assertNotNull((Object)savedRule1.getOwningReference());
        ActionServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)savedRule1.getOwningReference().getUuid());
        ActionServiceSystemTest.assertEquals((String)"incomming", (String)savedRule1.getRuleTypes()[0]);
        ActionServiceSystemTest.assertEquals((String)"This rule adds the classificable aspect", (String)savedRule1.getTitle());
        ActionServiceSystemTest.assertFalse((boolean)savedRule1.isExecuteAsynchronously());
        savedRule1.setTitle("The title has been updated");
        savedRule1.setExecuteAsynchronously(true);
        Rule[] saveResults2 = this.actionService.saveRules(BaseWebServiceSystemTest.contentReference, new Rule[]{savedRule1});
        ActionServiceSystemTest.assertNotNull((Object)saveResults2);
        ActionServiceSystemTest.assertEquals((int)1, (int)saveResults2.length);
        Rule savedRule2 = saveResults2[0];
        ActionServiceSystemTest.assertNotNull((Object)savedRule2);
        ActionServiceSystemTest.assertEquals((String)savedRule2.getRuleReference().getUuid(), (String)savedRule2.getRuleReference().getUuid());
        ActionServiceSystemTest.assertEquals((String)BaseWebServiceSystemTest.contentReference.getUuid(), (String)savedRule2.getOwningReference().getUuid());
        ActionServiceSystemTest.assertEquals((String)"incomming", (String)savedRule2.getRuleTypes()[0]);
        ActionServiceSystemTest.assertEquals((String)"The title has been updated", (String)savedRule2.getTitle());
        ActionServiceSystemTest.assertTrue((boolean)savedRule2.isExecuteAsynchronously());
        this.actionService.removeRules(BaseWebServiceSystemTest.contentReference, null);
        Rule[] rules3 = this.actionService.getRules(BaseWebServiceSystemTest.contentReference, null);
        ActionServiceSystemTest.assertNull((Object)rules3);
    }
}

