/*
 * Decompiled with CFR 0.152.
 */
package wiki;

import org.stringtree.factory.AbstractStringFetcher;
import org.stringtree.juicer.string.SplitLinesStringFilter;
import org.stringtree.juicer.string.StringStringSource;
import org.stringtree.regex.Matcher;
import org.stringtree.regex.Pattern;
import wiki.LineTransformContext;

public class ListRow
extends AbstractStringFetcher {
    private static Pattern pattern = Pattern.compile("^(\t+)(\\*|[1234567890]+)\\.?\\s*(.+)$");

    public Object getObject(String content) {
        LineTransformContext context = new LineTransformContext();
        StringBuffer buf = new StringBuffer();
        SplitLinesStringFilter rows = new SplitLinesStringFilter();
        rows.connectSource(new StringStringSource(content));
        String row = rows.nextString();
        while (row != null) {
            Matcher matcher = pattern.matcher(row);
            if (matcher.find() && matcher.groupCount() >= 3) {
                int indent = matcher.group(1).length();
                String type = "*".equals(matcher.group(2)) ? "ul" : "ol";
                String text = matcher.group(3);
                context.ensureType(buf, type, indent);
                buf.append("<li>");
                buf.append(text);
                buf.append("</li>\n");
            } else {
                buf.append(row);
                buf.append("\n");
            }
            row = rows.nextString();
        }
        context.endAll(buf);
        String ret = buf.toString();
        return ret;
    }
}

