/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.util.tract;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.stringtree.util.FilenameEndsWithDotTractRecognizer;
import org.stringtree.util.tract.StreamTractReader;
import org.stringtree.util.tract.Tract;
import org.stringtree.util.tract.TractRecognizer;

public class FileTractReader {
    public static void load(Tract tract, File file, boolean isTract) throws IOException {
        FileInputStream in = new FileInputStream(file);
        if (isTract) {
            StreamTractReader.load(tract, in);
        } else {
            StreamTractReader.loadText(tract, in);
        }
        ((InputStream)in).close();
        if (!tract.containsKey("~name")) {
            tract.put("~name", file.getName());
        }
        if (!tract.containsKey("~date")) {
            tract.put("~date", Long.toString(file.lastModified()));
        }
    }

    public static void load(Tract tract, File file, TractRecognizer rec) throws IOException {
        FileTractReader.load(tract, file, rec.isTract(file));
    }

    public static void load(Tract tract, File file) throws IOException {
        FileTractReader.load(tract, file, new FilenameEndsWithDotTractRecognizer());
    }

    public static void loadTract(Tract tract, File file) throws IOException {
        FileTractReader.load(tract, file, true);
    }

    public static void loadTextFile(Tract tract, File file) throws IOException {
        FileTractReader.load(tract, file, false);
    }

    public static Tract load(File file, TractRecognizer rec) {
        Tract ret = new Tract();
        try {
            FileTractReader.load(ret, file, rec);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Tract load(File file) {
        return FileTractReader.load(file, new FilenameEndsWithDotTractRecognizer());
    }
}

