/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class ClassUtils {
    public static Object rawCreate(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return Class.forName(className).newInstance();
    }

    public static void logCreationMessage(String message, Exception e, Writer out) {
        if (message != null && out != null) {
            PrintWriter pout = new PrintWriter(out);
            pout.println(message);
            e.printStackTrace(pout);
        }
    }

    public static void logCreationException(String className, Exception e, Writer out) {
        String message = null;
        if (e instanceof ClassNotFoundException) {
            message = "couldn't find class '" + className + "'";
        } else if (e instanceof IllegalAccessException) {
            message = "couldn't access class '" + className + "'";
        } else if (e instanceof InstantiationException) {
            message = "couldn't instantiate class '" + className + "'";
        } else if (e instanceof Exception) {
            message = "Unrecognized exception during object creation";
        }
        ClassUtils.logCreationMessage(message, e, out);
    }

    public static Object createObject(String className, Writer out) {
        Object ret = null;
        try {
            ret = ClassUtils.rawCreate(className);
        }
        catch (Exception e) {
            ClassUtils.logCreationException(className, e, out);
        }
        return ret;
    }

    public static Object createObject(String className, OutputStream out) {
        return ClassUtils.createObject(className, new OutputStreamWriter(out));
    }

    public static Object createObject(String className) {
        return ClassUtils.createObject(className, System.out);
    }
}

