/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.tract;

import org.stringtree.juicer.JuicerLockHelper;
import org.stringtree.juicer.tract.BasicTractFilter;
import org.stringtree.juicer.tract.TokenHelper;
import org.stringtree.juicer.tract.TractSource;
import org.stringtree.regex.Matcher;
import org.stringtree.regex.Pattern;
import org.stringtree.util.tract.Tract;

public class RegexTokenFinderTractFilter
extends BasicTractFilter {
    protected Pattern compiled;
    protected Matcher matcher;
    protected Tract input;
    protected String current;
    protected int index;
    protected boolean foundToken;
    protected int group;
    protected boolean lock;

    public RegexTokenFinderTractFilter(String from, boolean lock, int group) {
        this.compiled = Pattern.compile(from);
        this.lock = lock;
        this.group = group;
    }

    public RegexTokenFinderTractFilter(String from, boolean lock) {
        this(from, lock, 0);
    }

    public RegexTokenFinderTractFilter(String from, int group) {
        this(from, false, group);
    }

    public RegexTokenFinderTractFilter(String from) {
        this(from, false, 0);
    }

    private void startNextInput() {
        this.input = this.source.nextTract();
        if (this.input == null || JuicerLockHelper.isLocked(this.input)) {
            this.current = null;
            this.matcher = null;
            this.index = 0;
            this.foundToken = false;
        } else {
            this.current = this.input.getContent();
            this.matcher = this.compiled.matcher(this.current);
            this.index = 0;
            this.find();
        }
    }

    protected void find() {
        this.foundToken = this.matcher.find();
    }

    public void connectSource(TractSource source) {
        super.connectSource(source);
        this.startNextInput();
    }

    public Tract nextTract() {
        Tract ret = null;
        if (this.foundToken) {
            ret = new Tract("", this.input);
            if (this.index < this.matcher.start()) {
                ret.setContent(this.current.substring(this.index, this.matcher.start()));
                this.index = this.matcher.start();
            } else {
                this.processToken(ret);
                if (this.lock) {
                    JuicerLockHelper.lock(ret);
                }
            }
        } else if (this.current != null && this.index < this.current.length()) {
            ret = new Tract(this.current.substring(this.index, this.current.length()), this.input);
            this.index = this.current.length();
            this.startNextInput();
        } else if (this.current == null && this.input != null) {
            ret = this.input;
            this.startNextInput();
        }
        return ret;
    }

    protected void processToken(Tract ret) {
        ret.setContent(this.matcher.group(this.group));
        TokenHelper.setTokenFlag(ret);
        this.index = this.matcher.end();
        this.find();
    }
}

