/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.juicer.string;

import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import org.stringtree.juicer.string.PassStringFilter;
import org.stringtree.juicer.string.StringSource;

public class SplitStringFilter
extends PassStringFilter {
    protected CharacterIterator ci = null;
    protected char c = (char)65535;
    protected char separator = (char)32;
    protected StringBuffer buf = new StringBuffer();

    public SplitStringFilter(StringSource source) {
        super(source);
    }

    public SplitStringFilter(char separator, StringSource source) {
        super(source);
        this.setSeparator(separator);
    }

    public SplitStringFilter(char separator) {
        this.setSeparator(separator);
    }

    public SplitStringFilter() {
    }

    public void connectSource(StringSource source) {
        super.connectSource(source);
        this.startNextInput();
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    private void startNextInput() {
        String input = this.nextInput();
        if (input != null) {
            this.ci = new StringCharacterIterator(input);
            this.c = this.ci.first();
        } else {
            this.ci = null;
            this.c = (char)65535;
        }
    }

    protected String nextInput() {
        return this.source.nextString();
    }

    protected boolean accept(char c) {
        return c != this.separator;
    }

    protected boolean isSeparator(char c) {
        return c == this.separator;
    }

    protected void put(char c) {
        this.buf.append(c);
    }

    public String nextString() {
        this.buf.setLength(0);
        while (this.c != '\uffff') {
            if (this.accept(this.c)) {
                this.put(this.c);
            }
            this.c = this.ci.next();
            if (!this.isSeparator(this.c)) continue;
            this.c = this.ci.next();
            break;
        }
        if (this.c == '\uffff') {
            this.startNextInput();
        }
        if (this.buf.length() == 0 && this.ci == null) {
            return null;
        }
        return this.buf.toString();
    }
}

