/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.factory.memory;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.stringtree.factory.Container;
import org.stringtree.factory.Listable;
import org.stringtree.factory.Repository;

public class MapRepository
implements Repository,
Container,
Listable {
    protected Map map;
    boolean writable;

    public MapRepository(Map map, boolean writable) {
        this.map = map;
        this.writable = writable;
    }

    public MapRepository(Map map) {
        this(map, true);
    }

    public MapRepository(boolean writable) {
        this(new HashMap(), writable);
    }

    public MapRepository() {
        this(new HashMap(), true);
    }

    public Map getMap() {
        return this.map;
    }

    public boolean contains(String name) {
        if (this.writable && "fetcher.storer".equals(name)) {
            return true;
        }
        return this.map.containsKey(name);
    }

    public Object getObject(String name) {
        if (this.writable && "fetcher.storer".equals(name)) {
            return this;
        }
        return this.map.get(name);
    }

    public void put(String key, Object value) {
        this.map.put(key, value);
    }

    public void remove(String name) {
        this.map.remove(name);
    }

    public void clear() {
        this.map.clear();
    }

    public Iterator list() {
        return this.map.keySet().iterator();
    }
}

