/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.factory.flatfiles;

import java.io.File;
import org.stringtree.factory.flatfiles.BasicRepositoryFilenameFilter;

public class SuffixFilter
extends BasicRepositoryFilenameFilter {
    private String suffix;

    public SuffixFilter(String suffix) {
        this.suffix = suffix;
    }

    public boolean accept(File dir, String name) {
        return name.endsWith(this.suffix);
    }

    protected String externalName(String name) {
        return name + this.suffix;
    }

    protected String internalName(String name) {
        if (name.endsWith(this.suffix)) {
            name = name.substring(0, name.length() - this.suffix.length());
        }
        return name;
    }

    public String localName(File dir, File file) {
        String name = SuffixFilter.leafName(dir, file);
        String ret = this.internalName(name);
        return ret;
    }
}

