/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.factory.flatfiles;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.stringtree.factory.Listable;
import org.stringtree.factory.Repository;
import org.stringtree.factory.flatfiles.BasicRepositoryFilenameFilter;
import org.stringtree.factory.flatfiles.RepositoryFilenameFilter;
import org.stringtree.util.FileReadingUtils;
import org.stringtree.util.FileWritingUtils;

public class DirectoryRepository
implements Repository,
Listable {
    protected File dir;
    protected RepositoryFilenameFilter filter;
    protected boolean writable;

    public DirectoryRepository(File dir, RepositoryFilenameFilter filter, boolean writable) {
        this.dir = dir;
        this.filter = filter;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.writable = writable;
    }

    public DirectoryRepository(File dir, boolean writable) {
        this(dir, new BasicRepositoryFilenameFilter(), writable);
    }

    public DirectoryRepository(String dir, boolean writable) {
        this(new File(dir), writable);
    }

    public static boolean contains(File dir, String name) {
        return new File(dir, name).exists();
    }

    public boolean contains(String name) {
        if (this.writable && "fetcher.storer".equals(name)) {
            return true;
        }
        return this.filter.contains(this.dir, name);
    }

    public Object getObject(String name) {
        if (this.writable && "fetcher.storer".equals(name)) {
            return this;
        }
        return FileReadingUtils.readRawFile(this.fileToRead(name));
    }

    public File fileToRead(String name) {
        return this.filter.fileToRead(this.dir, name);
    }

    public void put(String key, Object value) {
        if (value != null) {
            File file = this.filter.fileToWrite(this.dir, key);
            File parent = file.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            try {
                FileWritingUtils.writeFile(file, value.toString());
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public void remove(String name) {
        this.filter.fileToWrite(this.dir, name).delete();
    }

    public void clear() {
        Iterator it = this.list();
        while (it.hasNext()) {
            File file = this.filter.fileToWrite(this.dir, (String)it.next());
            file.delete();
        }
    }

    public File fileToWrite(String name) {
        return this.filter.fileToWrite(this.dir, name);
    }

    public Iterator list() {
        File[] files = this.dir.listFiles(this.filter);
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < files.length; ++i) {
            String localName = this.filter.localName(this.dir, files[i]);
            names.add(localName);
        }
        return names.iterator();
    }
}

