/*
 * Decompiled with CFR 0.152.
 */
package org.stringtree.factory;

import java.util.Iterator;
import java.util.Map;
import org.stringtree.factory.ContextNotWritableException;
import org.stringtree.factory.Fetcher;
import org.stringtree.factory.FetcherHelper;
import org.stringtree.factory.Storer;
import org.stringtree.util.tract.Tract;

public class StorerHelper {
    public static Storer find(Fetcher context, boolean complain) {
        Storer ret = (Storer)context.getObject("fetcher.storer");
        if (ret == null && complain) {
            throw new ContextNotWritableException(context);
        }
        return ret;
    }

    public static Storer find(Fetcher context) {
        return StorerHelper.find(context, true);
    }

    public static void put(Fetcher context, String name, Object value) {
        StorerHelper.find(context).put(name, value);
    }

    public static void remove(Fetcher context, String name) {
        StorerHelper.find(context).remove(name);
    }

    public static void clear(Fetcher context) {
        StorerHelper.find(context).clear();
    }

    public static void putAll(Map source, Storer dest) {
        Iterator it = source.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            dest.put(key, source.get(key));
        }
    }

    public static void putAll(Map source, Fetcher dest) {
        StorerHelper.putAll(source, StorerHelper.find(dest));
    }

    public static void putAll(Tract source, Fetcher dest) {
        Storer storer = StorerHelper.find(dest);
        StorerHelper.putAll((Map)source, storer);
        storer.put("CONTENT", source.getContent());
    }

    public static void putAll(Fetcher source, Storer storer) {
        Iterator it = FetcherHelper.list(source);
        while (it.hasNext()) {
            String key = (String)it.next();
            storer.put(key, source.getObject(key));
        }
    }

    public static void putAll(Fetcher source, Fetcher dest) {
        StorerHelper.putAll(source, StorerHelper.find(dest));
    }

    public static Object ensure(Fetcher context, String name, Object dfl) {
        Object ret = context.getObject(name);
        if (null == ret) {
            StorerHelper.put(context, name, dfl);
            ret = context.getObject(name);
        }
        return ret;
    }
}

