/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.Page;
import com.efsol.friki.RepositoryDriver;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.stringtree.factory.Container;
import org.stringtree.factory.Repository;
import org.stringtree.factory.TractFetcher;
import org.stringtree.factory.TractStorer;
import org.stringtree.util.StringUtils;
import org.stringtree.util.tract.Tract;

public class PageRepository
implements TractFetcher,
TractStorer,
Repository,
Container {
    protected static DateFormat df = new SimpleDateFormat("dd MMMM yyyy");
    protected RepositoryDriver driver;

    public PageRepository(RepositoryDriver driver) {
        this.driver = driver;
    }

    public Object getObject(String name) {
        Tract page = null;
        if (this.driver.isReadable(name)) {
            page = this.driver.get(name);
        }
        if (page == null) {
            page = new Page(name);
        }
        return page;
    }

    public Tract get(String name) {
        Tract ret = (Tract)this.getObject(name);
        if (ret == null) {
            ret = new Page(name);
        }
        ret.put("escaped.name", this.escape(name));
        return ret;
    }

    public void put(String name, Tract page, boolean backup) {
        if (this.driver.isWritable(name)) {
            if (backup) {
                String previous = this.driver.backup(name);
                page.put("previous.version", previous);
            }
            page.put("last.edit", df.format(new Date()));
            this.driver.put(name, page);
        }
    }

    public void put(String name, Tract page) {
        this.put(name, page, true);
    }

    public void put(String name, Object obj) {
        if (obj instanceof Tract) {
            this.put(name, (Tract)obj, false);
        } else {
            System.out.println("Warning. Attempt to put unrecognized object '" + obj + "' into page repository");
        }
    }

    public Iterator matchingPages(String pattern) {
        if (StringUtils.isBlank(pattern)) {
            return this.driver.allPageNames();
        }
        ArrayList<String> ret = new ArrayList<String>();
        Iterator all = this.driver.allPageNames();
        while (all.hasNext()) {
            String content;
            String name = (String)all.next();
            if (name.indexOf(pattern) >= 0) {
                ret.add(name);
                continue;
            }
            Tract page = this.driver.get(name);
            if (page == null || (content = page.getContent()) == null || content.indexOf(pattern) < 0) continue;
            ret.add(name);
        }
        return ret.iterator();
    }

    public Iterator allPageNames() {
        return this.driver.allPageNames();
    }

    public void append(String pageName, String text) {
        Tract page = this.get(pageName);
        page.setContent(page.getContent() + text);
        this.put(pageName, page, false);
    }

    public void remove(String name) {
        this.driver.remove(name);
    }

    public void clear() {
        this.driver.clear();
    }

    public boolean contains(String name) {
        return this.driver.contains(name);
    }

    public String escape(String name) {
        return this.driver.escape(name);
    }

    public String unescape(String name) {
        return this.driver.unescape(name);
    }
}

