/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.ContentFilter;
import com.efsol.friki.DiffVisitor;
import com.efsol.friki.Page;
import com.efsol.friki.PageRepository;
import com.efsol.friki.Policy;
import com.efsol.friki.Renderer;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import jlibdiff.Diff;
import org.stringtree.factory.Container;
import org.stringtree.factory.DelegatedTractFetcher;
import org.stringtree.util.StringUtils;
import org.stringtree.util.tract.Tract;

public class Model
extends DelegatedTractFetcher
implements Container {
    private PageRepository repository;
    private Renderer renderer;
    private ContentFilter filter;
    private Policy policy;
    private DateFormat logFormat;

    public Model(PageRepository repository, Renderer renderer, ContentFilter filter, Policy policy) {
        super(repository);
        this.repository = repository;
        this.renderer = renderer;
        this.filter = filter;
        this.policy = policy;
        this.logFormat = new SimpleDateFormat(policy.get("date.format"));
    }

    public String ensurePage(String page) {
        page = page == null ? this.policy.get("dflPage") : this.repository.unescape(page);
        return page;
    }

    public String ensureMode(String mode) {
        String modes = this.policy.get("modes");
        if (!modes.endsWith(",")) {
            modes = modes + ",";
            this.policy.put("modes", modes);
        }
        if (mode == null || modes.indexOf("," + mode + ",") == -1) {
            mode = this.policy.get("viewMode");
        }
        return mode;
    }

    public Tract update(String name, String content) {
        Tract page = this.repository.get(name);
        page.setContent(content);
        this.repository.put(name, page);
        return page;
    }

    public Page search(String pattern) throws IOException {
        Page page = new Page("Search Results");
        page.put("hardlines", "true");
        page.put("pattern", pattern);
        StringWriter buf = new StringWriter();
        boolean found = false;
        Iterator it = this.repository.matchingPages(pattern);
        while (it.hasNext()) {
            buf.write("\n ");
            buf.write((String)it.next());
            found = true;
        }
        if (!found) {
            buf.write("Sorry, no pages matched the pattern '");
            buf.write(pattern);
            buf.write("'");
        }
        page.setContent(buf.toString());
        return page;
    }

    public void render(Tract page, String mode, Writer out, boolean isFiltered) throws IOException {
        this.renderer.render(page, mode, out, isFiltered);
    }

    public boolean contains(String name) {
        return this.repository.contains(name);
    }

    public void log(String page, String name, String author, boolean diffs) {
        StringBuffer ret = new StringBuffer(" ");
        ret.append(new Date());
        ret.append(" ...... ");
        ret.append(name);
        if (diffs) {
            ret.append(" (??" + name + ")");
        }
        if (!StringUtils.isBlank(author)) {
            ret.append(" ...... ");
            ret.append(author);
        }
        ret.append('\n');
        this.repository.append(page, ret.toString());
    }

    public String makeLinkSource(String name) {
        return this.filter.makeLinkSource(name);
    }

    public Object getObject(String name) {
        return this.repository.get(name);
    }

    public Tract get(String name) {
        String ensured = this.ensurePage(name);
        Tract ret = this.repository.get(ensured);
        return ret;
    }

    public String diff(String pageName) {
        String ret;
        Tract page = this.get(pageName);
        String previousName = page.getAttribute("previous.version");
        if (!StringUtils.isBlank(previousName) || "old/EmptyPage".equals(previousName)) {
            Tract previous = this.get(previousName);
            try {
                Diff d = new Diff();
                DiffVisitor visitor = new DiffVisitor();
                String newContent = page.getContent();
                String oldContent = previous.getContent();
                d.diffString(oldContent, newContent);
                ret = visitor.convert(d);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                ret = DiffVisitor.blockmessage("Oops! Error extracting page differences.");
            }
        } else {
            ret = DiffVisitor.blockmessage("No Previous Version.");
        }
        return ret;
    }
}

