/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import jlibdiff.Diff;
import jlibdiff.Hunk;
import jlibdiff.HunkAdd;
import jlibdiff.HunkChange;
import jlibdiff.HunkDel;
import jlibdiff.HunkVisitor;
import org.stringtree.util.StringUtils;

class DiffVisitor
extends HunkVisitor {
    private StringBuffer buf;
    private int softChanges = 0;
    private int hardChanges = 0;

    public DiffVisitor() {
        this.start();
    }

    public static String message(String text) {
        return "<tr><td colspan='4' class='diffmessage'>" + text + "</td></tr>";
    }

    public static String blockmessage(String text) {
        return "<p class='diff'><table class='difftable' width='95%' border='1'>\n" + DiffVisitor.message(text) + "</table></p>\n";
    }

    public void start() {
        this.buf = new StringBuffer("<p class='diff'><table class='difftable' width='95%' border='1'>\n<tr><th>Position</th><th>Added</th><th>Removed</th><th>Changed</th></tr>\n");
    }

    public void end() {
        this.buf.append("</table></p>\n");
    }

    public void load(Diff diff) {
        this.start();
        diff.accept(this);
        this.end();
    }

    public String convert(Diff diff) {
        this.load(diff);
        return this.toString();
    }

    private void addLines(Hunk hunk) {
        int low = hunk.lowLine(0);
        int high = hunk.highLine(0);
        this.buf.append("<td class='lines'>");
        this.buf.append(Integer.toString(low));
        if (high != low) {
            this.buf.append(" - ");
            this.buf.append(Integer.toString(high));
        }
        this.buf.append("</td>");
    }

    public void visitHunkAdd(HunkAdd hunk) {
        String text = hunk.getNewContents();
        if (!StringUtils.isBlank(text)) {
            this.buf.append("<tr>");
            this.addLines(hunk);
            this.buf.append("<td class='added'>");
            this.buf.append(text);
            this.buf.append("</td><td>&nbsp;</td><td>&nbsp;</td></tr>\n");
            ++this.hardChanges;
        } else {
            ++this.softChanges;
        }
    }

    public void visitHunkDel(HunkDel hunk) {
        String text = hunk.getOldContents();
        if (!StringUtils.isBlank(text)) {
            this.buf.append("<tr>");
            this.addLines(hunk);
            this.buf.append("<td>&nbsp;</td><td class='removed'>");
            this.buf.append(text);
            this.buf.append("</td><td>&nbsp;</td></tr>\n");
            ++this.hardChanges;
        } else {
            ++this.softChanges;
        }
    }

    public void visitHunkChange(HunkChange hunk) {
        String text = hunk.getNewContents();
        if (!StringUtils.isBlank(text)) {
            this.buf.append("<tr>");
            this.addLines(hunk);
            this.buf.append("<td>&nbsp;</td><td>&nbsp;</td><td class='changed'>");
            this.buf.append(text);
            this.buf.append("</td></tr>\n");
            ++this.hardChanges;
        } else {
            ++this.softChanges;
        }
    }

    public String toString() {
        String ret = this.hardChanges > 0 ? this.buf.toString() : (this.softChanges > 0 ? DiffVisitor.message("No significant changes (only whitespace)") : DiffVisitor.message("No Changes"));
        return ret;
    }
}

