/*
 * Decompiled with CFR 0.152.
 */
package com.efsol.friki;

import com.efsol.friki.TransformFilter;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.stringtree.factory.Fetcher;
import org.stringtree.factory.StorerHelper;
import org.stringtree.factory.TractFetcher;
import org.stringtree.factory.memory.MapStringRepository;
import org.stringtree.juicer.formatter.ExternalFormatter;
import org.stringtree.util.FileReadingUtils;

public class ClassicToHTMLFilter
extends TransformFilter {
    protected void setContext(Fetcher context, TractFetcher pages, Map remoteNames) {
        StorerHelper.put(context, "wiki.pages", pages);
        StorerHelper.put(context, "wiki.remoteNames", new MapStringRepository(remoteNames));
    }

    public ClassicToHTMLFilter(Fetcher context, TractFetcher pages, Map remoteNames, String spec) {
        this.setContext(context, pages, remoteNames);
        this.setConverter(new ExternalFormatter(spec, context));
    }

    public ClassicToHTMLFilter(Fetcher context, TractFetcher pages, Map remoteNames, File file) {
        this(context, pages, remoteNames, FileReadingUtils.readFile(file));
    }

    protected static Map loadRemoteDetails(File file) {
        HashMap<String, String> remoteNames = new HashMap<String, String>();
        String spec = FileReadingUtils.readFile(file);
        StringTokenizer tok = new StringTokenizer(spec, "\n");
        while (tok.hasMoreTokens()) {
            String line = tok.nextToken().trim();
            int sep = line.indexOf(" ");
            if (sep <= 0) continue;
            String name = line.substring(0, sep);
            String url = line.substring(sep + 1);
            remoteNames.put(name, url);
        }
        return remoteNames;
    }

    public String makeLinkSource(String name) {
        return "<a href='view?" + name + "'>" + name + "</a>";
    }
}

