/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

final class jmcanvas
extends Applet
implements Runnable {
    private static final int NEW = 0;
    private static final int LOST = 1;
    private static final int WON = 2;
    private static final int PLAY = 3;
    private static final int STOP = 4;
    private static final int NONE = 0;
    private static final int FIELD = 3;
    private static final int BUTTON = 4;
    private boolean buttoned;
    private int game;
    private int down;
    private int flags;
    private int seconds;
    private int left;
    private int[][] board;
    private long startTime;
    private long stopTime;
    private Thread ticker;
    private int marks;
    private int rows;
    private int cols;
    private int mines;
    private int width;
    private int height;
    private int row;
    private int col;
    private int push;
    private jmimage tfields;
    private static jmimage buttons;
    private static jmimage digits;
    private static jmimage fields;
    private static jmimage tields;

    public jmcanvas() {
        this.setBackground(Color.lightGray);
    }

    public void destroy() {
        this.ticker.interrupt();
    }

    private static void draw3DBorder(Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        graphics.setColor(color);
        graphics.drawLine(n, n2, n, n2 + n4);
        graphics.drawLine(n, n2, n + n3, n2);
        graphics.setColor(color2);
        graphics.drawLine(++n + n3, ++n2, n + n3, n2 + n4);
        graphics.drawLine(n, n2 + n4, n + n3, n2 + n4);
    }

    private static int getInteger(int n, int n2, int n3) {
        if (n < n2) {
            return n2;
        }
        if (n > n3) {
            return n3;
        }
        return n;
    }

    public int getCols() {
        return this.cols;
    }

    public int getMines() {
        return this.mines;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public int getRows() {
        return this.rows;
    }

    public int getTime() {
        return this.seconds;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0x20) == 0 || super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    private boolean inButton(Event event, int n, int n2) {
        return !event.metaDown() && n2 > 16 && n2 <= 40 && n + n + 24 >= this.width && n + n - 24 < this.width;
    }

    private int inField(Event event, int n, int n2) {
        if (n >= 12 && n2 >= 55 && n < this.width - 12 && n2 < this.height - 12) {
            this.col = n - 12 >> 4;
            this.row = n2 - 55 >> 4;
            if (event.metaDown()) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    public void init() {
        this.setMarks(true);
        if (buttons == null) {
            buttons = new jmimage((Applet)this, "button", 5, 0, 24, 24);
        }
        if (digits == null) {
            digits = new jmimage((Applet)this, "digit", 11, 0, 13, 23);
        }
        if (tields == null) {
            tields = new jmimage((Applet)this, "tield", 16, 12, 16, 16);
        }
        if (fields == null) {
            fields = new jmimage((Applet)this, "field", 16, 12, 16, 16);
        }
        this.tfields = fields != null ? fields : tields;
        this.ticker = new Thread((Runnable)this, "Ticker");
        this.ticker.setDaemon(true);
        this.ticker.start();
    }

    private static boolean isContained(Rectangle rectangle, int n, int n2, int n3, int n4) {
        return rectangle.x >= n && rectangle.y >= n2 && rectangle.x + rectangle.width <= n + n3 && rectangle.y + rectangle.height <= n2 + n4;
    }

    public Dimension minimumSize() {
        return new Dimension(this.width, this.height);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        Graphics graphics = this.getGraphics();
        this.buttoned = this.inButton(event, n, n2);
        if (this.buttoned) {
            this.down = 4;
            this.paintButton(graphics);
            return true;
        }
        if (this.game % 3 == 0) {
            this.push = this.inField(event, n, n2);
            if (this.push != 2 || this.board[this.row][this.col] >= 48) {
                this.down = 3;
                this.paintButton(graphics);
                this.repaintPush();
            } else {
                if ((this.board[this.row][this.col] & 0x10) != 0) {
                    --this.flags;
                }
                int[] nArray = this.board[this.row];
                int n3 = this.col;
                nArray[n3] = nArray[n3] + 16;
                int[] nArray2 = this.board[this.row];
                int n4 = this.col;
                nArray2[n4] = nArray2[n4] % this.marks;
                if ((this.board[this.row][this.col] & 0x10) != 0) {
                    ++this.flags;
                }
                this.paintFlags(graphics);
                this.push = 0;
                this.repaint(this.col * 16 + 12, this.row * 16 + 55, 16, 16);
            }
        }
        graphics.dispose();
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.buttoned) {
            int n3;
            int n4 = n3 = this.inButton(event, n, n2) ? 4 : 0;
            if (this.down != n3) {
                this.down = n3;
                Graphics graphics = this.getGraphics();
                this.paintButton(graphics);
                graphics.dispose();
            }
        } else if (this.down == 3) {
            this.repaintPush();
            this.push = this.inField(event, n, n2);
            this.repaintPush();
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.buttoned) {
            if (this.inButton(event, n, n2)) {
                this.newGame();
            }
        } else if (this.down == 3) {
            this.repaintPush();
            if (this.inField(event, n, n2) > 0) {
                switch (this.push) {
                    case 1: {
                        this.startTimer();
                        this.revealField(this.row, this.col);
                        break;
                    }
                    case 2: {
                        int n3;
                        int n4 = this.board[this.row][this.col];
                        int n5 = Math.max(0, this.row - 1);
                        while (n5 < Math.min(this.rows, this.row + 2)) {
                            n3 = Math.max(0, this.col - 1);
                            while (n3 < Math.min(this.cols, this.col + 2)) {
                                if ((this.board[n5][n3] & 0x30) == 16) {
                                    --n4;
                                }
                                ++n3;
                            }
                            ++n5;
                        }
                        if (n4 != 48) break;
                        n5 = Math.max(0, this.row - 1);
                        while (n5 < Math.min(this.rows, this.row + 2)) {
                            n3 = Math.max(0, this.col - 1);
                            while (n3 < Math.min(this.cols, this.col + 2)) {
                                this.revealField(n5, n3);
                                ++n3;
                            }
                            ++n5;
                        }
                        break;
                    }
                }
            }
            this.push = 0;
        }
        if (this.down != 0) {
            this.down = 0;
            Graphics graphics = this.getGraphics();
            this.paintButton(graphics);
            graphics.dispose();
        }
        return true;
    }

    public void newGame() {
        this.game = 0;
        this.down = 0;
        this.flags = 0;
        this.seconds = 0;
        this.left = this.rows * this.cols - this.mines;
        this.board = new int[this.rows][this.cols];
        int n = 0;
        while (n < this.mines) {
            int n2;
            int n3 = (int)(Math.random() * (double)this.rows);
            if (this.board[n3][n2 = (int)(Math.random() * (double)this.cols)] == 9) continue;
            this.board[n3][n2] = 9;
            int n4 = Math.max(0, n3 - 1);
            while (n4 < Math.min(this.rows, n3 + 2)) {
                int n5 = Math.max(0, n2 - 1);
                while (n5 < Math.min(this.cols, n2 + 2)) {
                    if (this.board[n4][n5] < 9) {
                        int[] nArray = this.board[n4];
                        int n6 = n5;
                        nArray[n6] = nArray[n6] + 1;
                    }
                    ++n5;
                }
                ++n4;
            }
            ++n;
        }
        this.repaint();
    }

    public void newGame(int n, int n2, int n3) {
        this.rows = jmcanvas.getInteger(n, 8, 24);
        this.height = this.rows * 16 + 67;
        this.cols = jmcanvas.getInteger(n2, 8, 30);
        this.width = this.cols * 16 + 24;
        this.mines = jmcanvas.getInteger(n3, 10, (this.rows - 1) * (this.cols - 1));
        this.resize(this.width, this.height);
        this.newGame();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        if (!jmcanvas.isContained(rectangle, 12, 55, this.width - 24, this.height - 67)) {
            jmcanvas.draw3DBorder(graphics, 0, 0, this.width - 2, this.height - 2, Color.white, Color.gray);
            jmcanvas.draw3DBorder(graphics, 1, 1, this.width - 4, this.height - 4, Color.white, Color.gray);
            jmcanvas.draw3DBorder(graphics, 2, 2, this.width - 6, this.height - 6, Color.white, Color.gray);
            jmcanvas.draw3DBorder(graphics, 9, 9, this.width - 20, 35, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, 10, 10, this.width - 22, 33, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, this.width - 26 >> 1, 15, 24, 24, Color.gray, Color.gray);
            jmcanvas.draw3DBorder(graphics, 16, 15, 39, 23, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, this.width - 56, 15, 39, 23, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, 9, 52, this.width - 20, this.height - 63, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, 10, 53, this.width - 22, this.height - 65, Color.gray, Color.white);
            jmcanvas.draw3DBorder(graphics, 11, 54, this.width - 24, this.height - 67, Color.gray, Color.white);
            this.paintButton(graphics);
            this.paintFlags(graphics);
            this.paintSeconds(graphics);
        }
        this.paintFields(graphics, rectangle.y - 55 >> 4, rectangle.x - 12 >> 4, rectangle.y + rectangle.height - 40 >> 4, rectangle.x + rectangle.width + 3 >> 4);
    }

    private void paintButton(Graphics graphics) {
        if (jmimage.isReady(buttons)) {
            boolean bl;
            boolean bl2 = bl = graphics == null;
            if (bl) {
                graphics = this.getGraphics();
            }
            if (graphics == null) {
                return;
            }
            buttons.drawImage(this.down == 0 ? this.game % 3 : this.down, graphics, this.width - 24 >> 1, 16);
            if (bl) {
                graphics.dispose();
            }
        }
    }

    private void paintFields(Graphics graphics, int n, int n2, int n3, int n4) {
        if (jmimage.isReady(this.tfields)) {
            if (n < 0) {
                n = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 > this.rows) {
                n3 = this.rows;
            }
            if (n4 > this.cols) {
                n4 = this.cols;
            }
            while (n < n3) {
                int n5 = n2;
                while (n5 < n4) {
                    int n6 = this.board[n][n5] >= 48 ? this.board[n][n5] & 0xF : (this.game == 2 ? 13 : (this.game == 1 && (this.board[n][n5] & 0x1F) == 9 ? 10 : (this.game == 1 && this.board[n][n5] >= 16 && this.board[n][n5] <= 24 ? 11 : ((this.board[n][n5] & 0x10) == 0 && n > this.row - this.push && n < this.row + this.push && n5 > this.col - this.push && n5 < this.col + this.push ? ((this.board[n][n5] & 0x20) == 0 ? 0 : 15) : 12 + (this.board[n][n5] >> 4)))));
                    this.tfields.drawImage(n6, graphics, n5 * 16 + 12, n * 16 + 55);
                    ++n5;
                }
                ++n;
            }
        }
    }

    private void paintFlags(Graphics graphics) {
        this.paintNumber(graphics, 17, 16, this.mines - this.flags);
    }

    private void paintNumber(Graphics graphics, int n, int n2, int n3) {
        if (jmimage.isReady(digits)) {
            int n4;
            boolean bl;
            boolean bl2 = bl = graphics == null;
            if (bl) {
                graphics = this.getGraphics();
            }
            if (graphics == null) {
                return;
            }
            if (n3 >= 0) {
                n4 = n3 / 100 % 10;
            } else {
                n3 = -n3;
                n4 = 10;
            }
            digits.drawImage(n4, graphics, n, n2);
            digits.drawImage(n3 / 10 % 10, graphics, n + 13, n2);
            digits.drawImage(n3 % 10, graphics, n + 26, n2);
            if (bl) {
                graphics.dispose();
            }
        }
    }

    private void paintSeconds(Graphics graphics) {
        this.paintNumber(graphics, this.width - 55, 16, this.seconds);
    }

    public Dimension preferredSize() {
        return new Dimension(this.width, this.height);
    }

    private void repaintFields() {
        this.repaint(12, 55, this.width - 24, this.height - 67);
    }

    private void repaintPush() {
        int n = Math.max(this.row + 1 - this.push, 0);
        int n2 = Math.max(this.col + 1 - this.push, 0);
        int n3 = Math.min(this.row + this.push, this.rows);
        int n4 = Math.min(this.col + this.push, this.cols);
        this.repaint(n2 * 16 + 12, n * 16 + 55, (n4 - n2) * 16, (n3 - n) * 16);
    }

    private void revealField(int n, int n2) {
        if ((this.board[n][n2] & 0x10) == 0) {
            int[] nArray = this.board[n];
            int n3 = n2;
            nArray[n3] = nArray[n3] | 0x30;
            this.repaint(n2 * 16 + 12, n * 16 + 55, 16, 16);
            switch (this.board[n][n2]) {
                case 57: {
                    this.stop(1);
                    this.repaintFields();
                    return;
                }
                case 48: {
                    int n4 = Math.max(0, n - 1);
                    while (n4 < Math.min(this.rows, n + 2)) {
                        int n5 = Math.max(0, n2 - 1);
                        while (n5 < Math.min(this.cols, n2 + 2)) {
                            this.revealField(n4, n5);
                            ++n5;
                        }
                        ++n4;
                    }
                    break;
                }
            }
            if (--this.left == 0) {
                this.stop(2);
                if (this.flags < this.mines) {
                    this.flags = this.mines;
                    Graphics graphics = this.getGraphics();
                    this.paintFlags(graphics);
                    graphics.dispose();
                    this.repaintFields();
                    return;
                }
            }
        }
    }

    public synchronized void run() {
        try {
            while (true) {
                if (this.game == 3) {
                    this.stopTime = System.currentTimeMillis();
                }
                long l = this.stopTime - this.startTime;
                this.seconds = (int)(l / 1000L);
                Graphics graphics = this.getGraphics();
                if (graphics != null) {
                    this.paintSeconds(graphics);
                    graphics.dispose();
                }
                if (this.game == 2) {
                    this.getParent().postEvent(new Event(this, 1001, this));
                }
                if (this.game == 3) {
                    this.wait((long)((this.seconds + 1) * 1000) - l);
                    continue;
                }
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public void setGraphics(boolean bl) {
        this.tfields = bl ? tields : fields;
        this.repaintFields();
    }

    public void setMarks(boolean bl) {
        this.marks = bl ? 48 : 32;
    }

    public synchronized void start() {
        if (this.game == 4) {
            this.game = 3;
            this.startTime += System.currentTimeMillis() - this.stopTime;
            this.notifyAll();
        }
    }

    private synchronized void startTimer() {
        if (this.game == 0) {
            this.game = 3;
            this.startTime = System.currentTimeMillis();
            this.notifyAll();
        }
    }

    public void stop() {
        this.stop(4);
    }

    private synchronized void stop(int n) {
        if (this.game == 3) {
            this.game = n;
            this.stopTime = System.currentTimeMillis();
            this.notifyAll();
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

