/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.lucene;

import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.util.lucene.DocumentImpl;
import java.io.IOException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class HitsImpl
implements Hits {
    private org.apache.lucene.search.Hits _hits;
    private long _start;
    private float _searchTime;
    private Document[] _docs;
    private int _length;
    private float[] _scores;

    public long getStart() {
        return this._start;
    }

    public void setStart(long start) {
        this._start = start;
    }

    public float getSearchTime() {
        return this._searchTime;
    }

    public void setSearchTime(float time) {
        this._searchTime = time;
    }

    public Document[] getDocs() {
        return this._docs;
    }

    public void setDocs(Document[] docs) {
        this._docs = docs;
    }

    public int getLength() {
        return this._length;
    }

    public void setLength(int length) {
        this._length = length;
    }

    public float[] getScores() {
        return this._scores;
    }

    public void setScores(float[] scores) {
        this._scores = scores;
    }

    public void setScores(Float[] scores) {
        float[] primScores = new float[scores.length];
        int i = 0;
        while (i < scores.length) {
            primScores[i] = scores[i].floatValue();
            ++i;
        }
        this.setScores(primScores);
    }

    public Document doc(int n) {
        try {
            if (this._docs[n] == null && this._hits != null) {
                this._docs[n] = new DocumentImpl(this._hits.doc(n));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._docs[n];
    }

    public float score(int n) {
        try {
            if (this._scores[n] == 0.0f && this._hits != null) {
                this._scores[n] = this._hits.score(n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._scores[n];
    }

    public Hits subset(int begin, int end) {
        HitsImpl subset = new HitsImpl();
        if (begin > -1 && begin <= end) {
            subset.setStart(this.getStart());
            Document[] subsetDocs = new DocumentImpl[this.getLength()];
            float[] subsetScores = new float[this.getLength()];
            int j = 0;
            int i = begin;
            while (i < end && i < this.getLength()) {
                subsetDocs[j] = this.doc(i);
                subsetScores[j] = this.score(i);
                ++i;
                ++j;
            }
            subset.setLength(j);
            subset.setDocs(subsetDocs);
            subset.setScores(subsetScores);
            this._searchTime = (float)(System.currentTimeMillis() - this._start) / 1000.0f;
            subset.setSearchTime(this.getSearchTime());
        }
        return subset;
    }

    public void recordHits(org.apache.lucene.search.Hits hits) throws IOException {
        this._hits = hits;
        this._length = hits.length();
        this._docs = new DocumentImpl[this._length];
        this._scores = new float[this._length];
    }

    private final /* synthetic */ void this() {
        this._docs = new DocumentImpl[0];
        this._scores = new float[0];
    }

    public HitsImpl() {
        this.this();
        this._start = System.currentTimeMillis();
    }
}

