/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.StringUtil;
import com.liferay.util.cal.CalendarUtil;

public class Validator {
    private static char[] _EMAIL_ADDRESS_SPECIAL_CHAR = new char[]{'.', '!', '#', '$', '%', '&', '\'', '*', '+', '-', '/', '=', '?', '^', '_', '`', '{', '|', '}', '~'};

    public static boolean equals(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean isAddress(String address) {
        if (Validator.isNull(address)) {
            return false;
        }
        String[] tokens = address.split("@");
        if (tokens.length != 2) {
            return false;
        }
        int i = 0;
        while (i < tokens.length) {
            char[] c = tokens[i].toCharArray();
            int j = 0;
            while (j < c.length) {
                if (Character.isWhitespace(c[j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public static boolean isChar(char c) {
        return Character.isLetter(c);
    }

    public static boolean isChar(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Validator.isChar(c[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDigit(char c) {
        char x = c;
        return x >= '0' && x <= '9';
    }

    public static boolean isDigit(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Validator.isDigit(c[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isHex(String s) {
        return !Validator.isNull(s);
    }

    public static boolean isHTML(String s) {
        if (Validator.isNull(s)) {
            return false;
        }
        return !(s.indexOf("<html>") == -1 && s.indexOf("<HTML>") == -1 || s.indexOf("</html>") == -1 && s.indexOf("</HTML>") == -1);
    }

    public static boolean isLUHN(String number) {
        if (number == null) {
            return false;
        }
        number = StringUtil.reverse(number);
        int total = 0;
        int i = 0;
        while (i < number.length()) {
            int x = 0;
            if ((i + 1) % 2 == 0) {
                x = Integer.parseInt(number.substring(i, i + 1)) * 2;
                if (x >= 10) {
                    String s = Integer.toString(x);
                    x = Integer.parseInt(s.substring(0, 1)) + Integer.parseInt(s.substring(1, 2));
                }
            } else {
                x = Integer.parseInt(number.substring(i, i + 1));
            }
            total += x;
            ++i;
        }
        return total % 10 == 0;
    }

    public static boolean isDate(int month, int day, int year) {
        return CalendarUtil.isDate(month, day, year);
    }

    public static boolean isGregorianDate(int month, int day, int year) {
        return CalendarUtil.isGregorianDate(month, day, year);
    }

    public static boolean isJulianDate(int month, int day, int year) {
        return CalendarUtil.isJulianDate(month, day, year);
    }

    public static boolean isEmailAddress(String ea) {
        int maxEmailLength;
        if (Validator.isNull(ea)) {
            return false;
        }
        int eaLength = ea.length();
        if (eaLength < 6) {
            return false;
        }
        int at = (ea = ea.toLowerCase()).indexOf(64);
        if (at > (maxEmailLength = 96) || at == -1 || at == 0 || at <= eaLength && at > eaLength - 5) {
            return false;
        }
        int dot = ea.lastIndexOf(46);
        if (dot == -1 || dot < at || dot > eaLength - 3) {
            return false;
        }
        if (ea.indexOf("..") != -1) {
            return false;
        }
        char[] name = ea.substring(0, at).toCharArray();
        int i = 0;
        while (i < name.length) {
            if (!(Validator.isChar(name[i]) || Validator.isDigit(name[i]) || Validator.isEmailAddressSpecialChar(name[i]))) {
                return false;
            }
            ++i;
        }
        if (Validator.isEmailAddressSpecialChar(name[0]) || Validator.isEmailAddressSpecialChar(name[name.length - 1])) {
            return false;
        }
        char[] host = ea.substring(at + 1, ea.length()).toCharArray();
        int i2 = 0;
        while (i2 < host.length) {
            if (!(Validator.isChar(host[i2]) || Validator.isDigit(host[i2]) || Validator.isEmailAddressSpecialChar(host[i2]))) {
                return false;
            }
            ++i2;
        }
        if (Validator.isEmailAddressSpecialChar(host[0]) || Validator.isEmailAddressSpecialChar(host[host.length - 1])) {
            return false;
        }
        if (ea.startsWith("postmaster@")) {
            return false;
        }
        return !ea.startsWith("root@");
    }

    public static boolean isEmailAddressSpecialChar(char c) {
        int i = 0;
        while (i < _EMAIL_ADDRESS_SPECIAL_CHAR.length) {
            if (c == _EMAIL_ADDRESS_SPECIAL_CHAR[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isValidEmailAddress(String ea) {
        return Validator.isEmailAddress(ea);
    }

    public static boolean isName(String name) {
        if (Validator.isNull(name)) {
            return false;
        }
        char[] c = name.trim().toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Validator.isChar(c[i]) && !Character.isWhitespace(c[i]) || c[i] == ',') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String number) {
        if (Validator.isNull(number)) {
            return false;
        }
        char[] c = number.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Validator.isDigit(c[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNull(String s) {
        if (s == null) {
            return true;
        }
        return (s = s.trim()).equals("null") || s.equals("");
    }

    public static boolean isNull(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotNull(String s) {
        return Validator.isNull(s) ^ true;
    }

    public static boolean isNotNull(Object[] array) {
        return Validator.isNull(array) ^ true;
    }

    public static boolean isPassword(String password) {
        if (Validator.isNull(password)) {
            return false;
        }
        if (password.length() < 4) {
            return false;
        }
        char[] c = password.toCharArray();
        int i = 0;
        while (i < c.length) {
            if (!Validator.isChar(c[i]) && !Validator.isDigit(c[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isPhoneNumber(String phoneNumber) {
        return Validator.isNumber(StringUtil.extractDigits(phoneNumber));
    }
}

