/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import EDU.oswego.cs.dl.util.concurrent.SyncSet;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.liferay.util.GetterUtil;
import com.liferay.util.SystemProperties;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TLinkedList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionFactory {
    static boolean useTrove = GetterUtil.getBoolean(SystemProperties.get("trove"), true);

    public static Map getHashMap() {
        if (useTrove) {
            return new THashMap();
        }
        return new HashMap();
    }

    public static Map getHashMap(int capacity) {
        if (useTrove) {
            return new THashMap(capacity);
        }
        return new HashMap(capacity);
    }

    public static Set getHashSet() {
        if (useTrove) {
            return new THashSet();
        }
        return new HashSet();
    }

    public static Set getHashSet(int capacity) {
        if (useTrove) {
            return new THashSet(capacity);
        }
        return new HashSet(capacity);
    }

    public static List getLinkedList() {
        if (useTrove) {
            return new TLinkedList();
        }
        return new LinkedList();
    }

    public static Map getSyncHashMap() {
        return new SyncMap(CollectionFactory.getHashMap(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    public static Map getSyncHashMap(int capacity) {
        return new SyncMap(CollectionFactory.getHashMap(capacity), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    public static Map getSyncHashMap(Map map) {
        return new SyncMap(map, (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    public static Set getSyncHashSet() {
        return new SyncSet(CollectionFactory.getHashSet(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    public static Set getSyncHashSet(int capacity) {
        return new SyncSet(CollectionFactory.getHashSet(capacity), (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    public static Set getSyncHashSet(Set set) {
        return new SyncSet(set, (ReadWriteLock)new WriterPreferenceReadWriteLock());
    }

    static {
        if (useTrove) {
            try {
                Class.forName("gnu.trove.THashMap");
            }
            catch (Exception e) {
                useTrove = false;
            }
        }
    }
}

