/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import javax.servlet.http.HttpServletRequest;

public class BrowserSniffer {
    private static final String _GZIP = "gzip";

    public static boolean acceptsGzip(HttpServletRequest req) {
        String acceptEncoding = req.getHeader("Accept-Encoding");
        return acceptEncoding != null && acceptEncoding.indexOf(_GZIP) != -1;
    }

    public static boolean is_ie(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase()).indexOf("msie") != -1;
    }

    public static boolean is_ie_4(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return BrowserSniffer.is_ie(req) && agent.indexOf("msie 4") != -1;
    }

    public static boolean is_ie_5(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return BrowserSniffer.is_ie(req) && agent.indexOf("msie 5.0") != -1;
    }

    public static boolean is_ie_5_5(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return BrowserSniffer.is_ie(req) && agent.indexOf("msie 5.5") != -1;
    }

    public static boolean is_ie_5_5_up(HttpServletRequest req) {
        return BrowserSniffer.is_ie(req) && !BrowserSniffer.is_ie_4(req) && !BrowserSniffer.is_ie_5(req);
    }

    public static boolean is_ie_6(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return BrowserSniffer.is_ie(req) && agent.indexOf("msie 6.0") != -1;
    }

    public static boolean is_ie_7(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return BrowserSniffer.is_ie(req) && agent.indexOf("msie 7.0") != -1;
    }

    public static boolean is_linux(HttpServletRequest req) {
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase()).matches(".*linux.*");
    }

    public static boolean is_mozilla(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase()).indexOf("mozilla") != -1 && agent.indexOf("spoofer") == -1 && agent.indexOf("compatible") == -1 && agent.indexOf("opera") == -1 && agent.indexOf("webtv") == -1 && agent.indexOf("hotjava") == -1;
    }

    public static boolean is_mozilla_1_3_up(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        if (BrowserSniffer.is_mozilla(req)) {
            int pos = agent.indexOf("gecko/");
            if (pos == -1) {
                return false;
            }
            String releaseDate = agent.substring(pos + 6, agent.length());
            if (releaseDate.compareTo("20030210") > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean is_ns_4(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        agent = agent.toLowerCase();
        return !BrowserSniffer.is_ie(req) && agent.indexOf("mozilla/4.") != -1;
    }

    public static boolean is_rtf(HttpServletRequest req) {
        return BrowserSniffer.is_ie_5_5_up(req) || BrowserSniffer.is_mozilla_1_3_up(req);
    }

    public static boolean is_safari(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String agent = req.getHeader("User-Agent");
        if (agent == null) {
            return false;
        }
        return (agent = agent.toLowerCase()).indexOf("safari") != -1;
    }

    public static boolean is_wml(HttpServletRequest req) {
        if (req == null) {
            return false;
        }
        String accept = req.getHeader("ACCEPT");
        if (accept == null) {
            return false;
        }
        return (accept = accept.toLowerCase()).indexOf("wap.wml") != -1;
    }
}

