/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.JMSException;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.Command;
import org.apache.activemq.command.ConnectionId;
import org.apache.activemq.command.ConnectionInfo;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.LocalTransactionId;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.ProducerId;
import org.apache.activemq.command.ProducerInfo;
import org.apache.activemq.command.Response;
import org.apache.activemq.command.SessionId;
import org.apache.activemq.command.SessionInfo;
import org.apache.activemq.command.ShutdownInfo;
import org.apache.activemq.command.TransactionId;
import org.apache.activemq.command.TransactionInfo;
import org.apache.activemq.transport.stomp.FrameTranslator;
import org.apache.activemq.transport.stomp.ProtocolException;
import org.apache.activemq.transport.stomp.ResponseHandler;
import org.apache.activemq.transport.stomp.StompFrame;
import org.apache.activemq.transport.stomp.StompFrameError;
import org.apache.activemq.transport.stomp.StompSubscription;
import org.apache.activemq.transport.stomp.StompTransportFilter;
import org.apache.activemq.util.ByteArrayOutputStream;
import org.apache.activemq.util.IdGenerator;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.util.LongSequenceGenerator;

public class ProtocolConverter {
    private static final IdGenerator connectionIdGenerator = new IdGenerator();
    private final ConnectionId connectionId = new ConnectionId(connectionIdGenerator.generateId());
    private final SessionId sessionId = new SessionId(this.connectionId, -1L);
    private final ProducerId producerId = new ProducerId(this.sessionId, 1L);
    private final LongSequenceGenerator consumerIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator messageIdGenerator = new LongSequenceGenerator();
    private final LongSequenceGenerator transactionIdGenerator = new LongSequenceGenerator();
    private final ConcurrentHashMap resposeHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap subscriptionsByConsumerId = new ConcurrentHashMap();
    private final Map transactions = new ConcurrentHashMap();
    private final StompTransportFilter transportFilter;
    private final Object commnadIdMutex = new Object();
    private int lastCommandId;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final FrameTranslator frameTranslator;

    public ProtocolConverter(StompTransportFilter stompTransportFilter, FrameTranslator translator) {
        this.transportFilter = stompTransportFilter;
        this.frameTranslator = translator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int generateCommandId() {
        Object object = this.commnadIdMutex;
        synchronized (object) {
            return this.lastCommandId++;
        }
    }

    protected ResponseHandler createResponseHandler(StompFrame command) {
        final String receiptId = (String)command.getHeaders().get("receipt");
        if (receiptId != null) {
            return new ResponseHandler(){

                public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                    StompFrame sc = new StompFrame();
                    sc.setAction("RECEIPT");
                    sc.setHeaders(new HashMap(1));
                    sc.getHeaders().put("receipt-id", receiptId);
                    ProtocolConverter.this.transportFilter.sendToStomp(sc);
                }
            };
        }
        return null;
    }

    protected void sendToActiveMQ(Command command, ResponseHandler handler) {
        command.setCommandId(this.generateCommandId());
        if (handler != null) {
            command.setResponseRequired(true);
            this.resposeHandlers.put((Object)new Integer(command.getCommandId()), (Object)handler);
        }
        this.transportFilter.sendToActiveMQ(command);
    }

    protected void sendToStomp(StompFrame command) throws IOException {
        this.transportFilter.sendToStomp(command);
    }

    public void onStompCommad(StompFrame command) throws IOException, JMSException {
        block13: {
            try {
                if (command.getClass() == StompFrameError.class) {
                    throw ((StompFrameError)command).getException();
                }
                String action = command.getAction();
                if (action.startsWith("SEND")) {
                    this.onStompSend(command);
                    break block13;
                }
                if (action.startsWith("ACK")) {
                    this.onStompAck(command);
                    break block13;
                }
                if (action.startsWith("BEGIN")) {
                    this.onStompBegin(command);
                    break block13;
                }
                if (action.startsWith("COMMIT")) {
                    this.onStompCommit(command);
                    break block13;
                }
                if (action.startsWith("ABORT")) {
                    this.onStompAbort(command);
                    break block13;
                }
                if (action.startsWith("SUB")) {
                    this.onStompSubscribe(command);
                    break block13;
                }
                if (action.startsWith("UNSUB")) {
                    this.onStompUnsubscribe(command);
                    break block13;
                }
                if (action.startsWith("CONNECT")) {
                    this.onStompConnect(command);
                    break block13;
                }
                if (action.startsWith("DISCONNECT")) {
                    this.onStompDisconnect(command);
                    break block13;
                }
                throw new ProtocolException("Unknown STOMP action: " + action);
            }
            catch (ProtocolException e) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter stream = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "UTF-8"));
                e.printStackTrace(stream);
                stream.close();
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("message", e.getMessage());
                String receiptId = (String)command.getHeaders().get("receipt");
                if (receiptId != null) {
                    headers.put("receipt-id", receiptId);
                }
                StompFrame errorMessage = new StompFrame("ERROR", headers, baos.toByteArray());
                this.sendToStomp(errorMessage);
                if (!e.isFatal()) break block13;
                this.getTransportFilter().onException(e);
            }
        }
    }

    protected void onStompSend(StompFrame command) throws IOException, JMSException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String stompTx = (String)headers.get("transaction");
        ActiveMQMessage message = this.convertMessage(command);
        message.setProducerId(this.producerId);
        MessageId id = new MessageId(this.producerId, this.messageIdGenerator.getNextSequenceId());
        message.setMessageId(id);
        message.setJMSTimestamp(System.currentTimeMillis());
        if (stompTx != null) {
            TransactionId activemqTx = (TransactionId)this.transactions.get(stompTx);
            if (activemqTx == null) {
                throw new ProtocolException("Invalid transaction id: " + stompTx);
            }
            message.setTransactionId(activemqTx);
        }
        message.onSend();
        this.sendToActiveMQ(message, this.createResponseHandler(command));
    }

    protected void onStompAck(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String messageId = (String)headers.get("message-id");
        if (messageId == null) {
            throw new ProtocolException("ACK received without a message-id to acknowledge!");
        }
        TransactionId activemqTx = null;
        String stompTx = (String)headers.get("transaction");
        if (stompTx != null && (activemqTx = (TransactionId)this.transactions.get(stompTx)) == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        boolean acked = false;
        Iterator iter = this.subscriptionsByConsumerId.values().iterator();
        while (iter.hasNext()) {
            StompSubscription sub = (StompSubscription)iter.next();
            MessageAck ack = sub.onStompMessageAck(messageId);
            if (ack == null) continue;
            ack.setTransactionId(activemqTx);
            this.sendToActiveMQ(ack, this.createResponseHandler(command));
            acked = true;
            break;
        }
        if (!acked) {
            throw new ProtocolException("Unexpected ACK received for message-id [" + messageId + "]");
        }
    }

    protected void onStompBegin(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String stompTx = (String)headers.get("transaction");
        if (!headers.containsKey("transaction")) {
            throw new ProtocolException("Must specify the transaction you are beginning");
        }
        if (this.transactions.get(stompTx) != null) {
            throw new ProtocolException("The transaction was allready started: " + stompTx);
        }
        LocalTransactionId activemqTx = new LocalTransactionId(this.connectionId, this.transactionIdGenerator.getNextSequenceId());
        this.transactions.put(stompTx, activemqTx);
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)0);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompCommit(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String stompTx = (String)headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = (TransactionId)this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)2);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompAbort(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String stompTx = (String)headers.get("transaction");
        if (stompTx == null) {
            throw new ProtocolException("Must specify the transaction you are committing");
        }
        TransactionId activemqTx = (TransactionId)this.transactions.remove(stompTx);
        if (activemqTx == null) {
            throw new ProtocolException("Invalid transaction id: " + stompTx);
        }
        TransactionInfo tx = new TransactionInfo();
        tx.setConnectionId(this.connectionId);
        tx.setTransactionId(activemqTx);
        tx.setType((byte)4);
        this.sendToActiveMQ(tx, this.createResponseHandler(command));
    }

    protected void onStompSubscribe(StompFrame command) throws ProtocolException {
        this.checkConnected();
        Map headers = command.getHeaders();
        String subscriptionId = (String)headers.get("id");
        String destination = (String)headers.get("destination");
        ActiveMQDestination actual_dest = this.frameTranslator.convertDestination(destination);
        ConsumerId id = new ConsumerId(this.sessionId, this.consumerIdGenerator.getNextSequenceId());
        ConsumerInfo consumerInfo = new ConsumerInfo(id);
        consumerInfo.setPrefetchSize(1000);
        consumerInfo.setDispatchAsync(true);
        String selector = (String)headers.remove("selector");
        consumerInfo.setSelector(selector);
        IntrospectionSupport.setProperties(consumerInfo, headers, "activemq.");
        consumerInfo.setDestination(this.frameTranslator.convertDestination(destination));
        StompSubscription stompSubscription = new StompSubscription(this, subscriptionId, consumerInfo);
        stompSubscription.setDestination(actual_dest);
        String ackMode = (String)headers.get("ack");
        if ("client".equals(ackMode)) {
            stompSubscription.setAckMode("client");
        } else {
            stompSubscription.setAckMode("auto");
        }
        this.subscriptionsByConsumerId.put((Object)id, (Object)stompSubscription);
        this.sendToActiveMQ(consumerInfo, this.createResponseHandler(command));
    }

    protected void onStompUnsubscribe(StompFrame command) throws ProtocolException {
        String subscriptionId;
        this.checkConnected();
        Map headers = command.getHeaders();
        ActiveMQDestination destination = null;
        Object o = headers.get("destination");
        if (o != null) {
            destination = this.frameTranslator.convertDestination((String)o);
        }
        if ((subscriptionId = (String)headers.get("id")) == null && destination == null) {
            throw new ProtocolException("Must specify the subscriptionId or the destination you are unsubscribing from");
        }
        Iterator iter = this.subscriptionsByConsumerId.values().iterator();
        while (iter.hasNext()) {
            StompSubscription sub = (StompSubscription)iter.next();
            if ((subscriptionId == null || !subscriptionId.equals(sub.getSubscriptionId())) && (destination == null || !destination.equals(sub.getDestination()))) continue;
            this.sendToActiveMQ(sub.getConsumerInfo().createRemoveCommand(), this.createResponseHandler(command));
            return;
        }
        throw new ProtocolException("No subscription matched.");
    }

    protected void onStompConnect(StompFrame command) throws ProtocolException {
        if (this.connected.get()) {
            throw new ProtocolException("Allready connected.");
        }
        final Map headers = command.getHeaders();
        String login = (String)headers.get("login");
        String passcode = (String)headers.get("passcode");
        String clientId = (String)headers.get("client-id");
        final ConnectionInfo connectionInfo = new ConnectionInfo();
        IntrospectionSupport.setProperties(connectionInfo, headers, "activemq.");
        connectionInfo.setConnectionId(this.connectionId);
        if (clientId != null) {
            connectionInfo.setClientId(clientId);
        } else {
            connectionInfo.setClientId("" + connectionInfo.getConnectionId().toString());
        }
        connectionInfo.setResponseRequired(true);
        connectionInfo.setUserName(login);
        connectionInfo.setPassword(passcode);
        this.sendToActiveMQ(connectionInfo, new ResponseHandler(){

            public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                SessionInfo sessionInfo = new SessionInfo(ProtocolConverter.this.sessionId);
                ProtocolConverter.this.sendToActiveMQ(sessionInfo, null);
                ProducerInfo producerInfo = new ProducerInfo(ProtocolConverter.this.producerId);
                ProtocolConverter.this.sendToActiveMQ(producerInfo, new ResponseHandler(){

                    public void onResponse(ProtocolConverter converter, Response response) throws IOException {
                        ProtocolConverter.this.connected.set(true);
                        HashMap<String, String> responseHeaders = new HashMap<String, String>();
                        responseHeaders.put("session", connectionInfo.getClientId());
                        String requestId = (String)headers.get("request-id");
                        if (requestId != null) {
                            responseHeaders.put("response-id", requestId);
                        }
                        StompFrame sc = new StompFrame();
                        sc.setAction("CONNECTED");
                        sc.setHeaders(responseHeaders);
                        ProtocolConverter.this.sendToStomp(sc);
                    }
                });
            }
        });
    }

    protected void onStompDisconnect(StompFrame command) throws ProtocolException {
        this.checkConnected();
        this.sendToActiveMQ(new ShutdownInfo(), this.createResponseHandler(command));
        this.connected.set(false);
    }

    protected void checkConnected() throws ProtocolException {
        if (!this.connected.get()) {
            throw new ProtocolException("Not connected.");
        }
    }

    public void onActiveMQCommad(Command command) throws IOException, JMSException {
        MessageDispatch md;
        StompSubscription sub;
        if (command.isResponse()) {
            Response response = (Response)command;
            ResponseHandler rh = (ResponseHandler)this.resposeHandlers.remove((Object)new Integer(response.getCorrelationId()));
            if (rh != null) {
                rh.onResponse(this, response);
            }
        } else if (command.isMessageDispatch() && (sub = (StompSubscription)this.subscriptionsByConsumerId.get((Object)(md = (MessageDispatch)command).getConsumerId())) != null) {
            sub.onMessageDispatch(md);
        }
    }

    public ActiveMQMessage convertMessage(StompFrame command) throws IOException, JMSException {
        ActiveMQMessage msg = this.frameTranslator.convertFrame(command);
        return msg;
    }

    public StompFrame convertMessage(ActiveMQMessage message) throws IOException, JMSException {
        return this.frameTranslator.convertMessage(message);
    }

    public StompTransportFilter getTransportFilter() {
        return this.transportFilter;
    }
}

