/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region.cursors;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.activemq.broker.region.Destination;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Topic;
import org.apache.activemq.broker.region.cursors.AbstractPendingMessageCursor;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class TopicStorePrefetch
extends AbstractPendingMessageCursor
implements MessageRecoveryListener {
    private static final Log log = LogFactory.getLog((Class)TopicStorePrefetch.class);
    private TopicMessageStore store;
    private final LinkedList batchList = new LinkedList();
    private String clientId;
    private String subscriberName;
    private MessageId lastMessageId;
    private Destination regionDestination;

    public TopicStorePrefetch(Topic topic, String clientId, String subscriberName) {
        this.regionDestination = topic;
        this.store = (TopicMessageStore)topic.getMessageStore();
        this.clientId = clientId;
        this.subscriberName = subscriberName;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
        this.store.resetBatching(this.clientId, this.clientId, null);
    }

    public boolean isEmpty() {
        return this.batchList.isEmpty();
    }

    public synchronized int size() {
        try {
            return this.store.getMessageCount(this.clientId, this.subscriberName);
        }
        catch (IOException e) {
            log.error((Object)(this + " Failed to get the outstanding message count from the store"), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public synchronized void addMessageLast(MessageReference node) throws Exception {
        if (node != null) {
            node.decrementReferenceCount();
        }
    }

    public synchronized boolean hasNext() {
        if (this.isEmpty()) {
            try {
                this.fillBatch();
            }
            catch (Exception e) {
                log.error((Object)"Failed to fill batch", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return !this.isEmpty();
    }

    public synchronized MessageReference next() {
        Message result = (Message)this.batchList.removeFirst();
        result.setRegionDestination(this.regionDestination);
        return result;
    }

    public void reset() {
    }

    public void finished() {
    }

    public void recoverMessage(Message message) throws Exception {
        message.setRegionDestination(this.regionDestination);
        message.incrementReferenceCount();
        this.batchList.addLast(message);
    }

    public void recoverMessageReference(String messageReference) throws Exception {
        throw new RuntimeException("Not supported");
    }

    protected void fillBatch() throws Exception {
        this.store.recoverNextMessages(this.clientId, this.subscriberName, this.lastMessageId, this.maxBatchSize, this);
        if (!this.batchList.isEmpty()) {
            Message message = (Message)this.batchList.getLast();
            this.lastMessageId = message.getMessageId();
        }
    }

    public String toString() {
        return "TopicStorePrefetch" + System.identityHashCode(this) + "(" + this.clientId + "," + this.subscriberName + ")";
    }

    synchronized void nextToDispatch(MessageId id) throws Exception {
        this.lastMessageId = this.store.getPreviousMessageIdToDeliver(this.clientId, this.clientId, id);
        this.store.resetBatching(this.clientId, this.clientId, id);
    }
}

