/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.Glyphs;
import org.apache.fop.fonts.truetype.FontFileReader;
import org.apache.fop.fonts.truetype.TTFCmapEntry;
import org.apache.fop.fonts.truetype.TTFDirTabEntry;
import org.apache.fop.fonts.truetype.TTFMtxEntry;
import org.apache.fop.fonts.truetype.UnicodeMapping;

public class TTFFile {
    static final byte NTABS = 24;
    static final int NMACGLYPHS = 258;
    static final int MAX_CHAR_CODE = 255;
    static final int ENC_BUF_SIZE = 1024;
    public static final boolean TRACE_ENABLED = false;
    private String encoding = "WinAnsiEncoding";
    private short firstChar = 0;
    private boolean isEmbeddable = true;
    private boolean hasSerifs = true;
    protected Map dirTabs;
    private Map kerningTab;
    private Map ansiKerningTab;
    private List cmaps;
    private List unicodeMapping;
    private int upem;
    private int nhmtx;
    private int postFormat;
    private int locaFormat;
    protected long lastLoca = 0L;
    private int numberOfGlyphs;
    private int nmGlyphs;
    protected TTFMtxEntry[] mtxTab;
    private int[] mtxEncoded = null;
    private String fontName = "";
    private String fullName = "";
    private String notice = "";
    private String familyName = "";
    private String subFamilyName = "";
    private long italicAngle = 0L;
    private long isFixedPitch = 0L;
    private int fontBBox1 = 0;
    private int fontBBox2 = 0;
    private int fontBBox3 = 0;
    private int fontBBox4 = 0;
    private int capHeight = 0;
    private int underlinePosition = 0;
    private int underlineThickness = 0;
    private int xHeight = 0;
    private int ascender = 0;
    private int descender = 0;
    private short lastChar = 0;
    private int[] ansiWidth;
    private Map ansiIndex;
    private TTFDirTabEntry currentDirTab;
    protected Log log = LogFactory.getLog(class$org$apache$fop$fonts$truetype$TTFFile == null ? (class$org$apache$fop$fonts$truetype$TTFFile = TTFFile.class$("org.apache.fop.fonts.truetype.TTFFile")) : class$org$apache$fop$fonts$truetype$TTFFile);
    static /* synthetic */ Class class$org$apache$fop$fonts$truetype$TTFFile;

    void seekTab(FontFileReader in, String name, long offset) throws IOException {
        TTFDirTabEntry dt = (TTFDirTabEntry)this.dirTabs.get(name);
        if (dt == null) {
            this.log.error("Dirtab " + name + " not found.");
        } else {
            in.seekSet(dt.getOffset() + offset);
            this.currentDirTab = dt;
        }
    }

    public int convertTTFUnit2PDFUnit(int n) {
        int ret;
        if (n < 0) {
            long rest1 = n % this.upem;
            long storrest = 1000L * rest1;
            long ledd2 = rest1 / storrest;
            ret = -(-1000 * n / this.upem - (int)ledd2);
        } else {
            ret = n / this.upem * 1000 + n % this.upem * 1000 / this.upem;
        }
        return ret;
    }

    private boolean readCMAP(FontFileReader in) throws IOException {
        this.unicodeMapping = new ArrayList();
        int mtxPtr = 0;
        this.seekTab(in, "cmap", 2L);
        int numCMap = in.readTTFUShort();
        long cmapUniOffset = 0L;
        this.log.info(numCMap + " cmap tables");
        for (int i = 0; i < numCMap; ++i) {
            int cmapPID = in.readTTFUShort();
            int cmapEID = in.readTTFUShort();
            long cmapOffset = in.readTTFULong();
            this.log.debug("Platform ID: " + cmapPID + " Encoding: " + cmapEID);
            if (cmapPID != 3 || cmapEID != 1) continue;
            cmapUniOffset = cmapOffset;
        }
        if (cmapUniOffset <= 0L) {
            this.log.fatal("Unicode cmap table not present");
            this.log.fatal("Unsupported format: Aborting");
            return false;
        }
        this.seekTab(in, "cmap", cmapUniOffset);
        int cmapFormat = in.readTTFUShort();
        in.readTTFUShort();
        this.log.info("CMAP format: " + cmapFormat);
        if (cmapFormat == 4) {
            int i;
            in.skip(2L);
            int cmapSegCountX2 = in.readTTFUShort();
            int cmapSearchRange = in.readTTFUShort();
            int cmapEntrySelector = in.readTTFUShort();
            int cmapRangeShift = in.readTTFUShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug("segCountX2   : " + cmapSegCountX2);
                this.log.debug("searchRange  : " + cmapSearchRange);
                this.log.debug("entrySelector: " + cmapEntrySelector);
                this.log.debug("rangeShift   : " + cmapRangeShift);
            }
            int[] cmapEndCounts = new int[cmapSegCountX2 / 2];
            int[] cmapStartCounts = new int[cmapSegCountX2 / 2];
            int[] cmapDeltas = new int[cmapSegCountX2 / 2];
            int[] cmapRangeOffsets = new int[cmapSegCountX2 / 2];
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapEndCounts[i] = in.readTTFUShort();
            }
            in.skip(2L);
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapStartCounts[i] = in.readTTFUShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapDeltas[i] = in.readTTFShort();
            }
            for (i = 0; i < cmapSegCountX2 / 2; ++i) {
                cmapRangeOffsets[i] = in.readTTFUShort();
            }
            int glyphIdArrayOffset = in.getCurrentPos();
            for (int i2 = 0; i2 < cmapStartCounts.length; ++i2) {
                this.log.debug(i2 + ": " + cmapStartCounts[i2] + " - " + cmapEndCounts[i2]);
                for (int j = cmapStartCounts[i2]; j <= cmapEndCounts[i2]; ++j) {
                    int glyphIdx;
                    if (j < 256 && j > this.lastChar) {
                        this.lastChar = (short)j;
                    }
                    if (mtxPtr >= this.mtxTab.length) continue;
                    if (cmapRangeOffsets[i2] != 0 && j != 65535) {
                        int glyphOffset = glyphIdArrayOffset + (cmapRangeOffsets[i2] / 2 + (j - cmapStartCounts[i2]) + i2 - cmapSegCountX2 / 2) * 2;
                        in.seekSet(glyphOffset);
                        glyphIdx = in.readTTFUShort() + cmapDeltas[i2] & 0xFFFF;
                        this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                        this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        List v = (List)this.ansiIndex.get(new Integer(j));
                        if (v != null) {
                            ListIterator e = v.listIterator();
                            while (e.hasNext()) {
                                Integer aIdx = (Integer)e.next();
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                                this.log.debug("Added width " + this.mtxTab[glyphIdx].getWx() + " uni: " + j + " ansi: " + aIdx);
                            }
                        }
                        this.log.debug("Idx: " + glyphIdx + " Delta: " + cmapDeltas[i2] + " Unicode: " + j + " name: " + this.mtxTab[glyphIdx].getName());
                    } else {
                        glyphIdx = j + cmapDeltas[i2] & 0xFFFF;
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        } else {
                            this.log.debug("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length);
                        }
                        this.unicodeMapping.add(new UnicodeMapping(glyphIdx, j));
                        if (glyphIdx < this.mtxTab.length) {
                            this.mtxTab[glyphIdx].getUnicodeIndex().add(new Integer(j));
                        } else {
                            this.log.debug("Glyph " + glyphIdx + " out of range: " + this.mtxTab.length);
                        }
                        List v = (List)this.ansiIndex.get(new Integer(j));
                        if (v != null) {
                            ListIterator e = v.listIterator();
                            while (e.hasNext()) {
                                Integer aIdx = (Integer)e.next();
                                this.ansiWidth[aIdx.intValue()] = this.mtxTab[glyphIdx].getWx();
                            }
                        }
                    }
                    if (glyphIdx >= this.mtxTab.length || this.mtxTab[glyphIdx].getUnicodeIndex().size() >= 2) continue;
                    ++mtxPtr;
                }
            }
        }
        return true;
    }

    private void printMaxMin() {
        int min = 255;
        int max = 0;
        for (int i = 0; i < this.mtxTab.length; ++i) {
            if (this.mtxTab[i].getIndex() < min) {
                min = this.mtxTab[i].getIndex();
            }
            if (this.mtxTab[i].getIndex() <= max) continue;
            max = this.mtxTab[i].getIndex();
        }
        this.log.info("Min: " + min);
        this.log.info("Max: " + max);
    }

    public void readFont(FontFileReader in) throws IOException {
        this.readFont(in, null);
    }

    private void initAnsiWidths() {
        int i;
        this.ansiWidth = new int[256];
        for (i = 0; i < 256; ++i) {
            this.ansiWidth[i] = this.mtxTab[0].getWx();
        }
        this.ansiIndex = new HashMap();
        for (i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            Integer ansi = new Integer(i);
            Integer uni = new Integer(Glyphs.WINANSI_ENCODING[i]);
            ArrayList<Integer> v = (ArrayList<Integer>)this.ansiIndex.get(uni);
            if (v == null) {
                v = new ArrayList<Integer>();
                this.ansiIndex.put(uni, v);
            }
            v.add(ansi);
        }
    }

    public boolean readFont(FontFileReader in, String name) throws IOException {
        if (!this.checkTTC(in, name)) {
            if (name == null) {
                throw new IllegalArgumentException("For TrueType collection you must specify which font to select (-ttcname)");
            }
            throw new IOException("Name does not exist in the TrueType collection: " + name);
        }
        this.readDirTabs(in);
        this.readFontHeader(in);
        this.getNumGlyphs(in);
        this.log.info("Number of glyphs in font: " + this.numberOfGlyphs);
        this.readHorizontalHeader(in);
        this.readHorizontalMetrics(in);
        this.initAnsiWidths();
        this.readPostScript(in);
        this.readOS2(in);
        this.readIndexToLocation(in);
        this.readGlyf(in);
        this.readName(in);
        this.readPCLT(in);
        boolean valid = this.readCMAP(in);
        if (!valid) {
            return false;
        }
        this.createCMaps();
        this.readKerning(in);
        return true;
    }

    private void createCMaps() {
        UnicodeMapping um;
        this.cmaps = new ArrayList();
        TTFCmapEntry tce = new TTFCmapEntry();
        ListIterator e = this.unicodeMapping.listIterator();
        UnicodeMapping lastMapping = um = (UnicodeMapping)e.next();
        tce.setUnicodeStart(um.getUIdx());
        tce.setGlyphStartIndex(um.getGIdx());
        while (e.hasNext()) {
            um = (UnicodeMapping)e.next();
            if (lastMapping.getUIdx() + 1 != um.getUIdx() || lastMapping.getGIdx() + 1 != um.getGIdx()) {
                tce.setUnicodeEnd(lastMapping.getUIdx());
                this.cmaps.add(tce);
                tce = new TTFCmapEntry();
                tce.setUnicodeStart(um.getUIdx());
                tce.setGlyphStartIndex(um.getGIdx());
            }
            lastMapping = um;
        }
        tce.setUnicodeEnd(um.getUIdx());
        this.cmaps.add(tce);
    }

    public String getWindowsName() {
        return this.familyName + "," + this.subFamilyName;
    }

    public String getPostScriptName() {
        if ("Regular".equals(this.subFamilyName) || "Roman".equals(this.subFamilyName)) {
            return this.familyName;
        }
        return this.familyName + "," + this.subFamilyName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getCharSetName() {
        return this.encoding;
    }

    public int getCapHeight() {
        return this.convertTTFUnit2PDFUnit(this.capHeight);
    }

    public int getXHeight() {
        return this.convertTTFUnit2PDFUnit(this.xHeight);
    }

    public int getFlags() {
        int flags = 32;
        if (this.italicAngle != 0L) {
            flags |= 0x40;
        }
        if (this.isFixedPitch != 0L) {
            flags |= 2;
        }
        if (this.hasSerifs) {
            flags |= 1;
        }
        return flags;
    }

    public String getStemV() {
        return "0";
    }

    public String getItalicAngle() {
        String ia = Short.toString((short)(this.italicAngle / 65536L));
        return ia;
    }

    public int[] getFontBBox() {
        int[] fbb = new int[]{this.convertTTFUnit2PDFUnit(this.fontBBox1), this.convertTTFUnit2PDFUnit(this.fontBBox2), this.convertTTFUnit2PDFUnit(this.fontBBox3), this.convertTTFUnit2PDFUnit(this.fontBBox4)};
        return fbb;
    }

    public int getLowerCaseAscent() {
        return this.convertTTFUnit2PDFUnit(this.ascender);
    }

    public int getLowerCaseDescent() {
        return this.convertTTFUnit2PDFUnit(this.descender);
    }

    public short getLastChar() {
        return this.lastChar;
    }

    public short getFirstChar() {
        return this.firstChar;
    }

    public int[] getWidths() {
        int[] wx = new int[this.mtxTab.length];
        for (int i = 0; i < wx.length; ++i) {
            wx[i] = this.convertTTFUnit2PDFUnit(this.mtxTab[i].getWx());
        }
        return wx;
    }

    public int getCharWidth(int idx) {
        return this.convertTTFUnit2PDFUnit(this.ansiWidth[idx]);
    }

    public Map getKerning() {
        return this.kerningTab;
    }

    public Map getAnsiKerning() {
        return this.ansiKerningTab;
    }

    public boolean isEmbeddable() {
        return this.isEmbeddable;
    }

    protected void readDirTabs(FontFileReader in) throws IOException {
        in.skip(4L);
        int ntabs = in.readTTFUShort();
        in.skip(6L);
        this.dirTabs = new HashMap();
        TTFDirTabEntry[] pd = new TTFDirTabEntry[ntabs];
        this.log.debug("Reading " + ntabs + " dir tables");
        for (int i = 0; i < ntabs; ++i) {
            pd[i] = new TTFDirTabEntry();
            this.dirTabs.put(pd[i].read(in), pd[i]);
        }
    }

    protected void readFontHeader(FontFileReader in) throws IOException {
        this.seekTab(in, "head", 18L);
        this.upem = in.readTTFUShort();
        in.skip(16L);
        this.fontBBox1 = in.readTTFShort();
        this.fontBBox2 = in.readTTFShort();
        this.fontBBox3 = in.readTTFShort();
        this.fontBBox4 = in.readTTFShort();
        in.skip(6L);
        this.locaFormat = in.readTTFShort();
    }

    protected void getNumGlyphs(FontFileReader in) throws IOException {
        this.seekTab(in, "maxp", 4L);
        this.numberOfGlyphs = in.readTTFUShort();
    }

    protected void readHorizontalHeader(FontFileReader in) throws IOException {
        this.seekTab(in, "hhea", 4L);
        this.ascender = in.readTTFShort();
        this.descender = in.readTTFShort();
        in.skip(26L);
        this.nhmtx = in.readTTFUShort();
        this.log.debug("Number of horizontal metrics: " + this.nhmtx);
        if (this.ascender == 0 || this.descender == 0) {
            this.seekTab(in, "OS/2", 68L);
            if (this.currentDirTab.getLength() >= 78L) {
                this.ascender = in.readTTFShort();
                this.descender = in.readTTFShort();
            }
        }
    }

    protected void readHorizontalMetrics(FontFileReader in) throws IOException {
        int i;
        this.seekTab(in, "hmtx", 0L);
        int mtxSize = Math.max(this.numberOfGlyphs, this.nhmtx);
        this.mtxTab = new TTFMtxEntry[mtxSize];
        for (i = 0; i < mtxSize; ++i) {
            this.mtxTab[i] = new TTFMtxEntry();
        }
        for (i = 0; i < this.nhmtx; ++i) {
            this.mtxTab[i].setWx(in.readTTFUShort());
            this.mtxTab[i].setLsb(in.readTTFUShort());
        }
        if (this.nhmtx < mtxSize) {
            int lastWidth = this.mtxTab[this.nhmtx - 1].getWx();
            for (int i2 = this.nhmtx; i2 < mtxSize; ++i2) {
                this.mtxTab[i2].setWx(lastWidth);
                this.mtxTab[i2].setLsb(in.readTTFUShort());
            }
        }
    }

    private final void readPostScript(FontFileReader in) throws IOException {
        this.seekTab(in, "post", 0L);
        this.postFormat = in.readTTFLong();
        this.italicAngle = in.readTTFULong();
        this.underlinePosition = in.readTTFShort();
        this.underlineThickness = in.readTTFShort();
        this.isFixedPitch = in.readTTFULong();
        in.skip(16L);
        this.log.debug("PostScript format: " + this.postFormat);
        switch (this.postFormat) {
            case 65536: {
                this.log.debug("PostScript format 1");
                for (int i = 0; i < Glyphs.MAC_GLYPH_NAMES.length; ++i) {
                    this.mtxTab[i].setName(Glyphs.MAC_GLYPH_NAMES[i]);
                }
                break;
            }
            case 131072: {
                int i;
                this.log.debug("PostScript format 2");
                int numGlyphStrings = 0;
                int l = in.readTTFUShort();
                for (int i2 = 0; i2 < l; ++i2) {
                    this.mtxTab[i2].setIndex(in.readTTFUShort());
                    if (this.mtxTab[i2].getIndex() > 257) {
                        ++numGlyphStrings;
                    }
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug("PostScript index: " + this.mtxTab[i2].getIndexAsString());
                }
                String[] psGlyphsBuffer = new String[numGlyphStrings];
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Reading " + numGlyphStrings + " glyphnames, that are not in the standard Macintosh" + " set. Total number of glyphs=" + l);
                }
                for (i = 0; i < psGlyphsBuffer.length; ++i) {
                    psGlyphsBuffer[i] = in.readTTFString(in.readTTFUByte());
                }
                for (i = 0; i < l; ++i) {
                    if (this.mtxTab[i].getIndex() < 258) {
                        this.mtxTab[i].setName(Glyphs.MAC_GLYPH_NAMES[this.mtxTab[i].getIndex()]);
                        continue;
                    }
                    if (this.mtxTab[i].isIndexReserved()) continue;
                    int k = this.mtxTab[i].getIndex() - 258;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(k + " i=" + i + " mtx=" + this.mtxTab.length + " ps=" + psGlyphsBuffer.length);
                    }
                    this.mtxTab[i].setName(psGlyphsBuffer[k]);
                }
                break;
            }
            case 196608: {
                this.log.debug("PostScript format 3");
                break;
            }
            default: {
                this.log.error("Unknown PostScript format: " + this.postFormat);
            }
        }
    }

    private final void readOS2(FontFileReader in) throws IOException {
        if (this.dirTabs.get("OS/2") != null) {
            this.seekTab(in, "OS/2", 8L);
            int fsType = in.readTTFUShort();
            this.isEmbeddable = fsType != 2;
        } else {
            this.isEmbeddable = true;
        }
    }

    protected final void readIndexToLocation(FontFileReader in) throws IOException {
        this.seekTab(in, "loca", 0L);
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            this.mtxTab[i].setOffset(this.locaFormat == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1));
        }
        this.lastLoca = this.locaFormat == 1 ? in.readTTFULong() : (long)(in.readTTFUShort() << 1);
    }

    private final void readGlyf(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("glyf");
        for (int i = 0; i < this.numberOfGlyphs - 1; ++i) {
            if (this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                in.seekSet(dirTab.getOffset() + this.mtxTab[i].getOffset());
                in.skip(2L);
                int[] bbox = new int[]{in.readTTFShort(), in.readTTFShort(), in.readTTFShort(), in.readTTFShort()};
                this.mtxTab[i].setBoundingBox(bbox);
                continue;
            }
            this.mtxTab[i].setBoundingBox(this.mtxTab[0].getBoundingBox());
        }
        long n = ((TTFDirTabEntry)this.dirTabs.get("glyf")).getOffset();
        for (int i = 0; i < this.numberOfGlyphs; ++i) {
            if (i + 1 >= this.mtxTab.length || this.mtxTab[i].getOffset() != this.mtxTab[i + 1].getOffset()) {
                in.seekSet(n + this.mtxTab[i].getOffset());
                in.skip(2L);
                int[] bbox = new int[]{in.readTTFShort(), in.readTTFShort(), in.readTTFShort(), in.readTTFShort()};
                this.mtxTab[i].setBoundingBox(bbox);
            } else {
                int bbox0 = this.mtxTab[0].getBoundingBox()[0];
                int[] bbox = new int[]{bbox0, bbox0, bbox0, bbox0};
                this.mtxTab[i].setBoundingBox(bbox);
            }
            this.log.debug(this.mtxTab[i].toString(this));
        }
    }

    private final void readName(FontFileReader in) throws IOException {
        this.seekTab(in, "name", 2L);
        int i = in.getCurrentPos();
        int n = in.readTTFUShort();
        int j = in.readTTFUShort() + i - 2;
        i += 4;
        while (n-- > 0) {
            in.seekSet(i);
            int platformID = in.readTTFUShort();
            int encodingID = in.readTTFUShort();
            int languageID = in.readTTFUShort();
            int k = in.readTTFUShort();
            int l = in.readTTFUShort();
            if (!(platformID != 1 && platformID != 3 || encodingID != 0 && encodingID != 1 || k != 1 && k != 2 && k != 0 && k != 4 && k != 6)) {
                in.seekSet(j + in.readTTFUShort());
                String txt = in.readTTFString(l);
                this.log.debug(platformID + " " + encodingID + " " + languageID + " " + k + " " + txt);
                switch (k) {
                    case 0: {
                        this.notice = txt;
                        break;
                    }
                    case 1: {
                        this.familyName = txt;
                        break;
                    }
                    case 2: {
                        this.subFamilyName = txt;
                        break;
                    }
                    case 4: {
                        this.fullName = txt;
                        break;
                    }
                    case 6: {
                        this.fontName = txt;
                    }
                }
                if (!this.notice.equals("") && !this.fullName.equals("") && !this.fontName.equals("") && !this.familyName.equals("") && !this.subFamilyName.equals("")) break;
            }
            i += 12;
        }
    }

    private final void readPCLT(FontFileReader in) throws IOException {
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("PCLT");
        if (dirTab != null) {
            in.seekSet(dirTab.getOffset() + 4L + 4L + 2L);
            this.xHeight = in.readTTFUShort();
            in.skip(4L);
            this.capHeight = in.readTTFUShort();
            in.skip(34L);
            int serifStyle = in.readTTFUByte();
            serifStyle >>= 6;
            this.hasSerifs = (serifStyle &= 3) != 1;
        } else {
            for (int i = 0; i < this.mtxTab.length; ++i) {
                if (!"H".equals(this.mtxTab[i].getName())) continue;
                this.capHeight = this.mtxTab[i].getBoundingBox()[3] - this.mtxTab[i].getBoundingBox()[1];
            }
        }
    }

    private final void readKerning(FontFileReader in) throws IOException {
        this.kerningTab = new HashMap();
        this.ansiKerningTab = new HashMap();
        TTFDirTabEntry dirTab = (TTFDirTabEntry)this.dirTabs.get("kern");
        if (dirTab != null) {
            this.seekTab(in, "kern", 2L);
            for (int n = in.readTTFUShort(); n > 0; --n) {
                in.skip(4L);
                int k = in.readTTFUShort();
                if ((k & 1) == 0 || (k & 2) != 0 || (k & 4) != 0) {
                    return;
                }
                if (k >> 8 != 0) continue;
                k = in.readTTFUShort();
                in.skip(6L);
                while (k-- > 0) {
                    int i = in.readTTFUShort();
                    int j = in.readTTFUShort();
                    short kpx = in.readTTFShort();
                    if (kpx == 0) continue;
                    Integer iObj = new Integer(i);
                    HashMap<Integer, Integer> adjTab = (HashMap<Integer, Integer>)this.kerningTab.get(iObj);
                    if (adjTab == null) {
                        adjTab = new HashMap<Integer, Integer>();
                    }
                    adjTab.put(new Integer(j), new Integer(this.convertTTFUnit2PDFUnit(kpx)));
                    this.kerningTab.put(iObj, adjTab);
                }
            }
            Iterator ae = this.kerningTab.keySet().iterator();
            while (ae.hasNext()) {
                Integer cidKey = (Integer)ae.next();
                HashMap<Integer, Integer> akpx = new HashMap<Integer, Integer>();
                Map ckpx = (Map)this.kerningTab.get(cidKey);
                Iterator aee = ckpx.keySet().iterator();
                while (aee.hasNext()) {
                    Integer cidKey2 = (Integer)aee.next();
                    Integer kern = (Integer)ckpx.get(cidKey2);
                    ListIterator uniMap = this.mtxTab[cidKey2].getUnicodeIndex().listIterator();
                    while (uniMap.hasNext()) {
                        Integer unicodeKey = (Integer)uniMap.next();
                        Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                        for (int u = 0; u < ansiKeys.length; ++u) {
                            akpx.put(ansiKeys[u], kern);
                        }
                    }
                }
                if (akpx.size() <= 0) continue;
                ListIterator uniMap = this.mtxTab[cidKey].getUnicodeIndex().listIterator();
                while (uniMap.hasNext()) {
                    Integer unicodeKey = (Integer)uniMap.next();
                    Integer[] ansiKeys = this.unicodeToWinAnsi(unicodeKey);
                    for (int u = 0; u < ansiKeys.length; ++u) {
                        this.ansiKerningTab.put(ansiKeys[u], akpx);
                    }
                }
            }
        }
    }

    public List getCMaps() {
        return this.cmaps;
    }

    protected final boolean checkTTC(FontFileReader in, String name) throws IOException {
        String tag = in.readTTFString(4);
        if ("ttcf".equals(tag)) {
            in.skip(4L);
            int numDirectories = (int)in.readTTFULong();
            long[] dirOffsets = new long[numDirectories];
            for (int i = 0; i < numDirectories; ++i) {
                dirOffsets[i] = in.readTTFULong();
            }
            this.log.info("This is a TrueType collection file with " + numDirectories + " fonts");
            this.log.info("Containing the following fonts: ");
            boolean found = false;
            long dirTabOffset = 0L;
            for (int i = 0; i < numDirectories; ++i) {
                in.seekSet(dirOffsets[i]);
                this.readDirTabs(in);
                this.readName(in);
                if (this.fullName.equals(name)) {
                    found = true;
                    dirTabOffset = dirOffsets[i];
                    this.log.info(this.fullName + " <-- selected");
                } else {
                    this.log.info(this.fullName);
                }
                this.notice = "";
                this.fullName = "";
                this.familyName = "";
                this.fontName = "";
                this.subFamilyName = "";
            }
            in.seekSet(dirTabOffset);
            return found;
        }
        in.seekSet(0L);
        return true;
    }

    private Integer[] unicodeToWinAnsi(int unicode) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 32; i < Glyphs.WINANSI_ENCODING.length; ++i) {
            if (unicode != Glyphs.WINANSI_ENCODING[i]) continue;
            ret.add(new Integer(i));
        }
        return ret.toArray(new Integer[0]);
    }

    public void printStuff() {
        System.out.println("Font name:   " + this.fontName);
        System.out.println("Full name:   " + this.fullName);
        System.out.println("Family name: " + this.familyName);
        System.out.println("Subfamily name: " + this.subFamilyName);
        System.out.println("Notice:      " + this.notice);
        System.out.println("xHeight:     " + this.convertTTFUnit2PDFUnit(this.xHeight));
        System.out.println("capheight:   " + this.convertTTFUnit2PDFUnit(this.capHeight));
        int italic = (int)(this.italicAngle >> 16);
        System.out.println("Italic:      " + italic);
        System.out.print("ItalicAngle: " + (short)(this.italicAngle / 65536L));
        if (this.italicAngle % 65536L > 0L) {
            System.out.print("." + (short)(this.italicAngle % 65536L * 1000L) / 65536);
        }
        System.out.println();
        System.out.println("Ascender:    " + this.convertTTFUnit2PDFUnit(this.ascender));
        System.out.println("Descender:   " + this.convertTTFUnit2PDFUnit(this.descender));
        System.out.println("FontBBox:    [" + this.convertTTFUnit2PDFUnit(this.fontBBox1) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox2) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox3) + " " + this.convertTTFUnit2PDFUnit(this.fontBBox4) + "]");
    }

    public static void main(String[] args) {
        try {
            TTFFile ttfFile = new TTFFile();
            FontFileReader reader = new FontFileReader(args[0]);
            String name = null;
            if (args.length >= 2) {
                name = args[1];
            }
            ttfFile.readFont(reader, name);
            ttfFile.printStuff();
        }
        catch (IOException ioe) {
            System.err.println("Problem reading font: " + ioe.toString());
            ioe.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

