/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.sandbox;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import nl.captcha.obscurity.GimpyEngine;

public class FishEyeGimpyImp
implements GimpyEngine {
    private Properties props = null;
    private int imgH;
    private int imgW;

    public BufferedImage getDistortedImage(BufferedImage image) {
        int i;
        Graphics2D graph = (Graphics2D)image.getGraphics();
        this.imgH = image.getHeight();
        this.imgW = image.getWidth();
        int hstripes = this.imgH / 7;
        int vstripes = this.imgW / 7;
        int hspace = this.imgH / (hstripes + 1);
        int vspace = this.imgW / (vstripes + 1);
        for (i = hspace; i < this.imgH; i += hspace) {
            graph.setColor(Color.blue);
            graph.drawLine(0, i, this.imgW, i);
        }
        for (i = vspace; i < this.imgW; i += vspace) {
            graph.setColor(Color.red);
            graph.drawLine(i, 0, i, this.imgH);
        }
        int[] pix = new int[this.imgH * this.imgW];
        int j = 0;
        for (int j1 = 0; j1 < this.imgW; ++j1) {
            for (int k1 = 0; k1 < this.imgH; ++k1) {
                pix[j] = image.getRGB(j1, k1);
                ++j;
            }
        }
        double distance = this.ranInt(this.imgW / 4, this.imgW / 3);
        int wMid = image.getWidth() / 2;
        int hMid = image.getHeight() / 2;
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int relX = x - wMid;
                int relY = y - hMid;
                double d1 = Math.sqrt(relX * relX + relY * relY);
                if (!(d1 < distance)) continue;
                int j2 = wMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(x - wMid));
                int k2 = hMid + (int)(this.fishEyeFormula(d1 / distance) * distance / d1 * (double)(y - hMid));
                image.setRGB(x, y, pix[j2 * this.imgH + k2]);
            }
        }
        return image;
    }

    public void setProperties(Properties props) {
        this.props = props;
    }

    private int ranInt(int i, int j) {
        double d = Math.random();
        return (int)((double)i + (double)(j - i + 1) * d);
    }

    private double fishEyeFormula(double s) {
        if (s < 0.0) {
            return 0.0;
        }
        if (s > 1.0) {
            return s;
        }
        return -0.75 * s * s * s + 1.5 * s * s + 0.25 * s;
    }

    public static void main(String[] args) {
        FishEyeGimpyImp imp = new FishEyeGimpyImp();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = new BufferedImage(3000, 2000, 2);
        image.getGraphics().setColor(Color.white);
        image.getGraphics().drawImage(image, 0, 0, null);
        image = imp.getDistortedImage(image);
        try {
            FileOutputStream out = new FileOutputStream(new File("c://cap/test" + System.currentTimeMillis() + ".jpg"));
            JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)out);
            JPEGEncodeParam param = encoder.getDefaultJPEGEncodeParam(image);
            param.setQuality(1.0f, true);
            encoder.encode(image, param);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

