/*
 * Decompiled with CFR 0.152.
 */
package nl.captcha.obscurity.imp;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Properties;
import nl.captcha.obscurity.BackgroundProducer;
import nl.captcha.util.Helper;

public class DefaultBackgroundImp
implements BackgroundProducer {
    private Properties props = null;

    public void setProperties(Properties props) {
        this.props = props;
    }

    public DefaultBackgroundImp() {
    }

    public DefaultBackgroundImp(Properties props) {
        this.props = props;
    }

    public BufferedImage addBackground(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        Color from = Helper.getColor(this.props, "cap.background.c.from", Color.lightGray);
        Color to = Helper.getColor(this.props, "cap.background.c.to", Color.white);
        BufferedImage resultImage = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)resultImage.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graph.setRenderingHints(hints);
        GradientPaint ytow = new GradientPaint(0.0f, 0.0f, from, width, height, to);
        graph.setPaint(ytow);
        graph.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        graph.drawImage((Image)image, 0, 0, null);
        return resultImage;
    }
}

