/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;

public class UsernameDialog
extends JDialog {
    private SecureFtpApplet parent;
    JPanel mainPanel = new JPanel();
    private String usernameMessage;
    private static JTextField usernameField;
    private transient boolean status;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton(new LString("ok_button.label", "OK").getString());
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
    private GridBagConstraints gbc = new GridBagConstraints();

    public UsernameDialog(SecureFtpApplet secureFtpApplet, String string, String string2) {
        super(secureFtpApplet.getBaseFrame(), string, true);
        this.parent = secureFtpApplet;
        this.getContentPane().setLayout(new BorderLayout());
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    UsernameDialog.this.setResizable(false);
                }
            });
        }
        this.usernameMessage = string2;
        this.getMainPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.addButtonListeners();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
    }

    static /* synthetic */ boolean access$1(UsernameDialog usernameDialog) {
        return usernameDialog.status;
    }

    private void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!usernameField.getText().trim().equals("")) {
                    UsernameDialog.this.status = true;
                    UsernameDialog.this.dispose();
                } else {
                    UsernameDialog.this.getToolkit().beep();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("cancelling username request", 2);
                UsernameDialog.this.parent.getServerUtil().closeConnection();
                UsernameDialog.this.status = false;
                UsernameDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    UsernameDialog.this.parent.getServerUtil().closeConnection();
                    UsernameDialog.this.status = false;
                    UsernameDialog.this.dispose();
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        usernameField.requestFocus();
    }

    private GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    private void getMainPanel() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(315, 70));
        this.mainPanel.add((Component)new JLabel("  " + this.usernameMessage), this.getGBC(0, 17, 1.0, 1.0, 0, 0, 1, 2));
        usernameField = new JTextField(15);
        this.mainPanel.add((Component)usernameField, this.getGBC(0, 10, 1.0, 1.0, 0, 2, 4, 1));
        this.unSetEnterEvent(usernameField);
    }

    protected boolean getStatus() {
        return this.status;
    }

    public static String getUsername(SecureFtpApplet secureFtpApplet, String string) {
        LString lString = new LString("username_for_host.msg", "Enter your username for \"[^0]\"");
        lString.replace(0, string);
        return UsernameDialog.getUsername(secureFtpApplet, new LString("username_required.title", "Username required").getString(), String.valueOf(lString.getString()) + ":");
    }

    public static String getUsername(SecureFtpApplet secureFtpApplet, String string, String string2) {
        UsernameDialog usernameDialog = new UsernameDialog(secureFtpApplet, string, string2);
        boolean bl2 = usernameDialog.getStatus();
        if (bl2) {
            return usernameField.getText();
        }
        return null;
    }

    private void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }
}

