/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.Keymap;

public class UserPassDialog
extends JDialog {
    private SecureFtpApplet parent;
    JPanel mainPanel = new JPanel();
    private String hostname;
    private static JTextField usernameField;
    private static JPasswordField passwordField;
    private transient boolean status;
    private JPanel buttonPanel = new JPanel();
    private JButton okButton = new JButton(new LString("ok_button.label", "OK").getString());
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
    private GridBagConstraints gbc = new GridBagConstraints();

    public UserPassDialog(SecureFtpApplet secureFtpApplet, String string) {
        super(secureFtpApplet.getBaseFrame(), new LString("login_required.title", "Login required").getString(), true);
        this.parent = secureFtpApplet;
        this.hostname = string;
        this.getContentPane().setLayout(new BorderLayout());
        this.getMainPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
        this.addButtonListeners();
        this.getContentPane().add((Component)this.mainPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
    }

    static /* synthetic */ boolean access$1(UserPassDialog userPassDialog) {
        return userPassDialog.status;
    }

    private void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.okButton);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!usernameField.getText().trim().equals("")) {
                    UserPassDialog.this.status = true;
                    UserPassDialog.this.dispose();
                } else {
                    UserPassDialog.this.getToolkit().beep();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("cancelling user/pass request", 2);
                UserPassDialog.this.parent.getServerUtil().closeConnection();
                UserPassDialog.this.status = false;
                UserPassDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    UserPassDialog.this.parent.getServerUtil().closeConnection();
                    UserPassDialog.this.status = false;
                    UserPassDialog.this.dispose();
                }
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        usernameField.requestFocus();
    }

    private GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    private void getMainPanel() {
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setPreferredSize(new Dimension(315, 100));
        this.mainPanel.add((Component)new JLabel("  " + new LString("connection_info.hostname.label", "Hostname").getString() + ":"), this.getGBC(0, 17, 0.5, 1.0, 1, 0, 1, 2));
        this.mainPanel.add((Component)new JLabel(this.hostname), this.getGBC(0, 17, 0.5, 1.0, 2, 0, 1, 2));
        this.mainPanel.add((Component)new JLabel("  " + new LString("connection_info.username.label", "Username").getString() + ":"), this.getGBC(0, 17, 0.5, 1.0, 1, 2, 1, 2));
        usernameField = new JTextField(15);
        this.mainPanel.add((Component)usernameField, this.getGBC(0, 17, 0.5, 1.0, 2, 2, 1, 2));
        this.mainPanel.add((Component)new JLabel("  " + new LString("open_connection.password.label", "Password").getString() + ":"), this.getGBC(0, 17, 0.5, 1.0, 1, 4, 1, 2));
        passwordField = new JPasswordField(15);
        this.mainPanel.add((Component)passwordField, this.getGBC(0, 17, 0.5, 1.0, 2, 4, 1, 2));
        this.unSetEnterEvent(usernameField);
        this.unSetEnterEvent(passwordField);
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    usernameField.requestFocus();
                    UserPassDialog.this.setResizable(false);
                }
            });
        }
    }

    protected boolean getStatus() {
        return this.status;
    }

    public static Vector getUserPass(SecureFtpApplet secureFtpApplet, String string) {
        UserPassDialog userPassDialog = new UserPassDialog(secureFtpApplet, string);
        boolean bl2 = userPassDialog.getStatus();
        if (bl2) {
            Vector<Object> vector = new Vector<Object>();
            vector.addElement(usernameField.getText());
            vector.addElement(passwordField.getPassword());
            return vector;
        }
        return null;
    }

    private void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }
}

