/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.FtpThread;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.TransferProgressThread;
import edu.sdsc.secureftp.network.exception.FtpAbortException;
import edu.sdsc.secureftp.network.exception.FtpException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class TransferStatusDialog
extends JDialog {
    private JButton cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
    private JPanel infoPanel = null;
    private JPanel dataPanel = null;
    private JPanel xfrPanel = null;
    private JPanel xfrInfoPanel = null;
    private JPanel progPanel = null;
    private JPanel progressBarPanel = null;
    private JPanel buttonPanel = new JPanel();
    private JProgressBar progressBar = new JProgressBar(0, 100);
    private JLabel fileLabel = null;
    private JLabel dataLabel = null;
    private SecureFtpApplet gui;
    private FtpThread transfer;

    public TransferStatusDialog(SecureFtpApplet secureFtpApplet, FtpThread ftpThread) {
        super(secureFtpApplet.getBaseFrame(), new LString("transferring_data.title", "Transferring Data ...").getString(), false);
        this.gui = secureFtpApplet;
        this.transfer = ftpThread;
        this.getContentPane().setLayout(new BorderLayout());
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TransferStatusDialog.this.setResizable(false);
                }
            });
        }
        this.getContentPane().add((Component)this.getInfoPanel(), "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.buttonPanel.add(this.cancelButton);
        SwingUtilities.getRootPane(this).setDefaultButton(this.cancelButton);
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TransferStatusDialog.this.abortTransfer();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.gui.getContentPane());
        ((Component)this).setVisible(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                    TransferStatusDialog.this.abortTransfer();
                }
            }
        });
        this.transfer.start();
        new TransferProgressThread(this, this.transfer, this.gui.getLocalData()).start();
    }

    private void abortTransfer() {
        this.transfer.stop();
        try {
            this.gui.getFtpNet().abort();
            this.gui.getLocalUtil().list();
            this.gui.getServerUtil().list();
        }
        catch (FtpAbortException ftpAbortException) {
        }
        catch (FtpException ftpException) {}
        this.dispose();
    }

    public JLabel getDataLabel() {
        if (this.dataLabel == null) {
            this.dataLabel = new JLabel();
            this.dataLabel.setFont(new Font("Dialog", 0, 12));
        }
        return this.dataLabel;
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new JPanel();
            this.dataPanel.add(this.getDataLabel());
        }
        return this.dataPanel;
    }

    public JLabel getFileLabel() {
        if (this.fileLabel == null) {
            this.fileLabel = new JLabel();
            this.fileLabel.setFont(new Font("Dialog", 0, 12));
        }
        return this.fileLabel;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setPreferredSize(new Dimension(300, 100));
            this.infoPanel.setLayout(new BorderLayout());
            this.infoPanel.add((Component)this.getXfrPanel(), "North");
            this.infoPanel.add((Component)this.getProgPanel(), "Center");
            this.infoPanel.add((Component)this.getDataPanel(), "South");
        }
        return this.infoPanel;
    }

    private JPanel getProgPanel() {
        if (this.progPanel == null) {
            this.progPanel = new JPanel();
            this.progPanel.setLayout(new BorderLayout());
            this.progPanel.add((Component)this.getProgressBarPanel(), "Center");
        }
        return this.progPanel;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private JPanel getProgressBarPanel() {
        if (this.progressBarPanel == null) {
            this.progressBarPanel = new JPanel();
            this.progressBar.setValue(this.progressBar.getMinimum());
            this.progressBarPanel.setLayout(new FlowLayout());
            this.progressBarPanel.add(this.progressBar);
        }
        return this.progressBarPanel;
    }

    private JPanel getXfrInfoPanel() {
        if (this.xfrInfoPanel == null) {
            this.xfrInfoPanel = new JPanel();
            this.xfrInfoPanel.setLayout(new BorderLayout());
            this.xfrInfoPanel.add((Component)new JLabel(this.transfer.getLabelCaption()), "North");
            this.getFileLabel().setText(this.transfer.getLabelText());
            this.xfrInfoPanel.add((Component)this.getFileLabel(), "South");
        }
        return this.xfrInfoPanel;
    }

    private JPanel getXfrPanel() {
        if (this.xfrPanel == null) {
            this.xfrPanel = new JPanel();
            this.xfrPanel.setLayout(new BorderLayout());
            this.xfrPanel.add(Box.createVerticalStrut(5), "North");
            this.xfrPanel.add(Box.createHorizontalStrut(10), "West");
            this.xfrPanel.add((Component)this.getXfrInfoPanel(), "Center");
            this.xfrPanel.add(Box.createHorizontalStrut(10), "East");
        }
        return this.xfrPanel;
    }
}

