/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.gui.CloseListener;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class SessionLoggingFrame
extends JInternalFrame {
    private JTextArea sessionTA;
    private JScrollPane scrollPane;
    private JPanel buttonPanel = null;
    private SecureFtpApplet parent;

    public SessionLoggingFrame(SecureFtpApplet secureFtpApplet) {
        super(new LString("session_log.title", "Session Log").getString(), true, true, true, true);
        this.parent = secureFtpApplet;
        int n2 = this.parent.getPrefs().getWidth() - 200;
        int n3 = this.parent.getPrefs().getHeight() / 2;
        this.setBounds((this.parent.getPrefs().getWidth() - n2) / 2, (this.parent.getPrefs().getHeight() - n3) / 3, n2, n3);
        this.addVetoableChangeListener(new CloseListener());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.sessionTA = new JTextArea(5, 40);
        this.scrollPane = new JScrollPane(this.sessionTA);
        container.add((Component)this.scrollPane, "Center");
        container.add((Component)this.getButtonPanel(), "South");
        this.sessionTA.setEditable(false);
        this.setVisible(false);
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            JButton jButton = new JButton(new LString("close_button.label", "Close").getString());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SessionLoggingFrame.this.setVisible(false);
                }
            });
            JButton jButton2 = new JButton(new LString("clear_button.label", "Clear").getString());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SessionLoggingFrame.this.getSessionTA().selectAll();
                    SessionLoggingFrame.this.getSessionTA().replaceRange("", 0, SessionLoggingFrame.this.getSessionTA().getSelectionEnd());
                }
            });
            this.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 27) {
                        SessionLoggingFrame.this.setVisible(false);
                    }
                }
            });
            this.buttonPanel.setLayout(new FlowLayout());
            this.buttonPanel.add(jButton);
            this.buttonPanel.add(jButton2);
            SwingUtilities.getRootPane(this).setDefaultButton(jButton);
        }
        return this.buttonPanel;
    }

    protected JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTextArea getSessionTA() {
        return this.sessionTA;
    }
}

