/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FtpGet;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.ListPanel;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.SortDecorator;
import edu.sdsc.secureftp.gui.TransferStatusDialog;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.exception.FtpException;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ServerListPanel
extends ListPanel
implements Constants {
    private BasicFtp net;
    private SecureFtpApplet parent;

    public ServerListPanel(SecureFtpApplet secureFtpApplet, BasicFtp basicFtp) {
        super(secureFtpApplet);
        this.setName("server");
        this.parent = secureFtpApplet;
        this.setLayout(new BorderLayout());
        this.scrollPane = this.createTable();
        this.scrollPane.setBackground(Color.white);
        this.add((Component)this.scrollPane, "Center");
        this.net = basicFtp;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                block13: {
                    long l2;
                    if (mouseEvent.getClickCount() > 0) {
                        ServerListPanel.this.parent.getServerUtil().enableButtonBar();
                    }
                    if (mouseEvent.getClickCount() != 2) break block13;
                    String string = (String)ServerListPanel.this.tableView.getValueAt(ServerListPanel.this.tableView.getSelectedRow(), 1);
                    try {
                        l2 = Long.parseLong((String)ServerListPanel.this.tableView.getValueAt(ServerListPanel.this.tableView.getSelectedRow(), 2));
                    }
                    catch (Exception exception) {
                        l2 = 0L;
                    }
                    if (ServerListPanel.this.dirStruct.get(string).equals("%")) {
                        ServerListPanel.this.parent.getServerUtil().cdup();
                    } else if (ServerListPanel.this.dirStruct.get(string).equals("d")) {
                        try {
                            ServerListPanel.this.parent.getServerUtil().changeDir(string);
                        }
                        catch (Exception exception) {
                            ServerListPanel.this.parent.getServerFrame().setStatus(new LString("unable_change_dir.msg", "Cannot change directory").getString());
                        }
                    } else if (ServerListPanel.this.dirStruct.get(string).equals("f")) {
                        ServerListPanel.this.download(string, l2, 'f');
                    } else {
                        try {
                            ServerListPanel.this.parent.getServerUtil().changeDir(string);
                        }
                        catch (FtpNotADirectoryException ftpNotADirectoryException) {
                            ServerListPanel.this.download(string, l2, 'f');
                        }
                    }
                }
            }
        };
        this.tableView.addMouseListener(mouseAdapter);
        final SortDecorator sortDecorator = new SortDecorator(this.tableView.getModel());
        this.tableView.setModel(sortDecorator);
        JTableHeader jTableHeader = this.tableView.getTableHeader();
        jTableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = tableView.getColumnModel();
                int n2 = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n3 = tableView.convertColumnIndexToModel(n2);
                sortDecorator.sort(n3);
                parent.getServerPanel().repaint();
            }
        });
    }

    public void clearSelections() {
        this.tableView.removeRowSelectionInterval(0, this.tableView.getRowCount() - 1);
        this.dirStruct.clear();
        this.parent.getServerUtil().disableButtonBar();
    }

    protected void download(String string, long l2, char c10) {
        LString lString = new LString("network_busy.download.msg", "You cannot download at this time");
        if (this.parent.getServerUtil().networkBusy(lString.getString())) {
            return;
        }
        try {
            try {
                if (l2 == -1L) {
                    l2 = this.parent.getFtpNet().size(string);
                }
            }
            catch (FtpException ftpException) {
            }
            Object var7_5 = null;
            this.parent.setNetworkStatus(0);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.parent.setNetworkStatus(0);
            throw throwable;
        }
        this.download(new FileEntry[]{new FileEntry(c10, l2, string)});
    }

    protected void download(FileEntry[] fileEntryArray) {
        LString lString = new LString("network_busy.download.msg", "You cannot download at this time");
        if (this.parent.getServerUtil().networkBusy(lString.getString())) {
            return;
        }
        this.parent.setTransferStatusDialog(new TransferStatusDialog(this.parent, new FtpGet(this.parent, fileEntryArray, this.parent.getServerUtil().getMode())));
    }

    protected String getFileType(String string) {
        return (String)this.dirStruct.get(string);
    }

    protected void handleDrop(FileEntry[] fileEntryArray, Point point) {
        try {
            if (this.tableView.rowAtPoint(point) > 0) {
                try {
                    if (this.dirStruct.get(this.tableView.getValueAt(this.tableView.rowAtPoint(point), 1)).equals("d")) {
                        this.parent.getServerUtil().changeDir((String)this.tableView.getValueAt(this.tableView.rowAtPoint(point), 1));
                    }
                    this.parent.getLocalPanel().upload(fileEntryArray);
                }
                catch (Exception exception) {
                    this.parent.getServerFrame().setStatus(new LString("unable_change_dir.msg", "Cannot change directory").getString());
                }
            } else {
                this.parent.getLocalPanel().upload(fileEntryArray);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.parent.getLocalPanel().upload(fileEntryArray);
        }
    }
}

