/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.ServerCloseListener;
import edu.sdsc.secureftp.gui.ServerListPanel;
import edu.sdsc.secureftp.gui.StatusPanel;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JToolBar;

public class ServerFrame
extends JInternalFrame {
    private ServerListPanel serverPanel;
    private StatusPanel statusPanel;
    private JPanel colorPanel;
    private JPanel optionPanel;
    private JPanel navPanel;
    private JToolBar buttonBar;
    private JTextField dirTextField;
    private SecureFtpApplet parent;
    private JButton deleteButton;
    private JButton downloadButton;
    private JButton renameButton;
    private JButton stopButton;

    public ServerFrame(SecureFtpApplet secureFtpApplet, BasicFtp basicFtp) {
        super("Server", true, true, true, true);
        this.parent = secureFtpApplet;
        int n2 = this.parent.getWidth() / 2 - 10;
        int n3 = this.parent.getHeight() - 75;
        if (this.parent.isApplication()) {
            n2 = this.parent.getPrefs().getInternalWidth();
            n3 = this.parent.getPrefs().getInternalHeight();
        }
        this.setBounds(n2 + 10, 5, n2, n3);
        this.addVetoableChangeListener(new ServerCloseListener(this.parent, this.parent.getServerUtil()));
        this.serverPanel = new ServerListPanel(this.parent, basicFtp);
        this.serverPanel.setBackground(Color.white);
        this.optionPanel = new JPanel();
        this.optionPanel.setLayout(new BorderLayout());
        this.navPanel = new JPanel();
        this.navPanel.setLayout(new BorderLayout());
        this.statusPanel = new StatusPanel(this.parent, true);
        this.dirTextField = new JTextField(20);
        this.dirTextField.setBorder(BorderFactory.createEtchedBorder());
        this.navPanel.add((Component)this.getButtonBar(), "North");
        this.navPanel.add(Box.createHorizontalStrut(12), "West");
        this.navPanel.add((Component)this.dirTextField, "Center");
        this.navPanel.add(Box.createHorizontalStrut(12), "East");
        this.navPanel.add(Box.createVerticalStrut(5), "South");
        this.colorPanel = new JPanel();
        this.colorPanel.setPreferredSize(new Dimension(365, 5));
        this.colorPanel.add(new JLabel(""));
        this.optionPanel.add((Component)this.navPanel, "North");
        this.optionPanel.add((Component)this.colorPanel, "South");
        this.getContentPane().add((Component)this.optionPanel, "North");
        this.getContentPane().add((Component)this.serverPanel, "Center");
        this.getContentPane().add((Component)this.statusPanel, "South");
        this.setVisible(false);
        this.addListeners();
    }

    private void addListeners() {
        this.dirTextField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                block2: {
                    if (keyEvent.getKeyCode() != 10) break block2;
                    try {
                        ServerFrame.this.parent.getServerUtil().changeDir(ServerFrame.this.dirTextField.getText());
                    }
                    catch (FtpNotADirectoryException ftpNotADirectoryException) {
                        LString lString = new LString("not_a_valid_dir.msg", "[^0]: not a valid directory");
                        lString.replace(0, ServerFrame.this.dirTextField.getText());
                        new ErrorDialog(lString.getString(), new LString("not_a_dir.title", "Not a directory").getString());
                    }
                }
            }
        });
    }

    protected void delayedStatusReset(int n2) {
        this.statusPanel.delayedStatusReset(n2);
    }

    private JToolBar getButtonBar() {
        if (this.buttonBar == null) {
            this.buttonBar = new JToolBar();
            this.buttonBar.setOrientation(0);
            this.buttonBar.setFloatable(false);
            JButton jButton = new JButton(new ImageIcon(this.getClass().getResource("images/back.gif")));
            jButton.setToolTipText(new LString("internal_frame.cdup.tooltip", "Up one directory").getString());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("back button clicked", 3);
                    ServerFrame.this.parent.getServerUtil().cdup();
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                }
            });
            this.deleteButton = new JButton(new ImageIcon(this.getClass().getResource("images/delete.gif")));
            this.deleteButton.setToolTipText(new LString("internal_frame.delete.tooltip", "Delete").getString());
            this.deleteButton.setEnabled(true);
            this.deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    LString lString;
                    debug.println("delete button clicked", 3);
                    FileEntry[] fileEntryArray = ServerFrame.this.serverPanel.getSelectedEntries();
                    LString lString2 = new LString("delete_confirmation.title", "Delete confirmation");
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                    if (fileEntryArray == null) {
                        ServerFrame.this.getToolkit().beep();
                        ServerFrame.this.setStatus(new LString("select_an_item.msg", "You must select an item.").getString());
                        return;
                    }
                    if (fileEntryArray.length == 1) {
                        if (fileEntryArray[0].getName().equals("..")) {
                            ServerFrame.this.getToolkit().beep();
                            ServerFrame.this.setStatus(new LString("cannot_delete_item.msg", "You cannot delete this item.").getString());
                            return;
                        }
                        lString = new LString("delete_file.msg", "Delete \"[^0]\"?");
                        lString.replace(0, fileEntryArray[0].getName());
                    } else {
                        lString = new LString("delete_all_selected_items.msg", "Delete ALL selected items?");
                    }
                    int n2 = JOptionPane.showConfirmDialog(ServerFrame.this.parent.getContentPane(), String.valueOf(lString.getString()) + "\n", lString2.getString(), 1);
                    switch (n2) {
                        case 0: {
                            ServerFrame.this.parent.getServerUtil().delete(fileEntryArray);
                            break;
                        }
                        case 1: 
                        case 2: {
                            ServerFrame.this.setStatus(new LString("delete_cancelled.msg", "Deletion cancelled.").getString());
                            break;
                        }
                    }
                }
            });
            this.downloadButton = new JButton(new ImageIcon(this.getClass().getResource("images/download.gif")));
            this.downloadButton.setToolTipText(new LString("internal_frame.download.tooltip", "Download").getString());
            this.downloadButton.setEnabled(true);
            this.downloadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("download button clicked", 3);
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                    if (!ServerFrame.this.parent.getFtpNet().isConnected()) {
                        ServerFrame.this.getToolkit().beep();
                        ServerFrame.this.setStatus(new LString("not_connected_download.msg", "You must be connected to download.").getString());
                        return;
                    }
                    FileEntry[] fileEntryArray = ServerFrame.this.serverPanel.getSelectedEntries();
                    if (fileEntryArray == null) {
                        String string = JOptionPane.showInputDialog(ServerFrame.this.parent.getContentPane(), String.valueOf(new LString("download_file.msg", "Download file or directory").getString()) + ":", new LString("download_file.title", "Download file/directory").getString(), 3);
                        if (string != null && !string.trim().equals("")) {
                            ServerFrame.this.serverPanel.download(string, -1L, '?');
                        }
                    } else {
                        ServerFrame.this.serverPanel.download(fileEntryArray);
                    }
                }
            });
            JButton jButton2 = new JButton(new ImageIcon(this.getClass().getResource("images/mkdir.gif")));
            jButton2.setToolTipText(new LString("internal_frame.mkdir.tooltip", "Create new directory").getString());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("mkdir button clicked", 3);
                    String string = String.valueOf(new LString("create_new_dir.msg", "Create new directory").getString()) + ":";
                    String string2 = new LString("create_new_dir.title", "Create new directory").getString();
                    String string3 = JOptionPane.showInputDialog(ServerFrame.this.parent.getContentPane(), string, string2, 3);
                    if (string3 != null) {
                        ServerFrame.this.parent.getServerUtil().mkdir(string3);
                        ServerFrame.this.parent.getServerUtil().list();
                    } else {
                        ServerFrame.this.setStatus(new LString("create_dir_cancelled.msg", "Create new directory cancelled").getString());
                    }
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                }
            });
            JButton jButton3 = new JButton(new ImageIcon(this.getClass().getResource("images/refresh.gif")));
            jButton3.setToolTipText(new LString("internal_frame.refresh.tooltip", "Refresh").getString());
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("refresh button clicked", 3);
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                    try {
                        ServerFrame.this.parent.getServerUtil().list();
                    }
                    catch (Exception exception) {
                        ServerFrame.this.setStatus(new LString("listing_failed.msg", "Listing failed").getString());
                    }
                }
            });
            this.renameButton = new JButton(new ImageIcon(this.getClass().getResource("images/rename.gif")));
            this.renameButton.setToolTipText(new LString("internal_frame.rename.tooltip", "Rename").getString());
            this.renameButton.setEnabled(true);
            this.renameButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("rename button clicked", 3);
                    FileEntry[] fileEntryArray = ServerFrame.this.serverPanel.getSelectedEntries();
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                    if (fileEntryArray == null) {
                        ServerFrame.this.getToolkit().beep();
                        ServerFrame.this.setStatus(new LString("select_an_item.msg", "You must select an item.").getString());
                        return;
                    }
                    if (fileEntryArray.length > 1) {
                        ServerFrame.this.getToolkit().beep();
                        ServerFrame.this.setStatus(new LString("rename_select_max_one.msg", "Select only one file to rename").getString());
                        return;
                    }
                    if (fileEntryArray[0].getName().equals("..")) {
                        ServerFrame.this.getToolkit().beep();
                        ServerFrame.this.setStatus(new LString("cannot_rename_item.msg", "You cannot rename this item.").getString());
                        return;
                    }
                    LString lString = new LString("rename_file.msg", "New name for \"[^0]\"");
                    lString.replace(0, fileEntryArray[0].getName());
                    LString lString2 = new LString("rename.title", "Rename");
                    String string = JOptionPane.showInputDialog(ServerFrame.this.parent.getContentPane(), String.valueOf(lString.getString()) + ":", lString2.getString(), 3);
                    if (string != null) {
                        ServerFrame.this.parent.getServerUtil().rename(fileEntryArray[0].getName(), string);
                        ServerFrame.this.parent.getServerUtil().list();
                    } else {
                        ServerFrame.this.setStatus(new LString("rename_cancelled.msg", "Rename cancelled.").getString());
                    }
                }
            });
            this.stopButton = new JButton(new ImageIcon(this.getClass().getResource("images/stop.gif")));
            this.stopButton.setToolTipText(new LString("internal_frame.stop.tooltip", "Stop").getString());
            this.stopButton.setEnabled(false);
            this.stopButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    debug.println("stop button clicked", 3);
                    ServerFrame.this.parent.getLocalPanel().requestFocus();
                    try {
                        ServerFrame.this.parent.getFtpNet().abort();
                        ServerFrame.this.parent.getServerUtil().stopList();
                        ServerFrame.this.stopButton.setEnabled(false);
                    }
                    catch (Exception exception) {}
                }
            });
            this.buttonBar.addSeparator();
            this.buttonBar.add(this.downloadButton);
            this.buttonBar.addSeparator();
            this.buttonBar.add(jButton);
            this.buttonBar.add(jButton3);
            this.buttonBar.add(this.stopButton);
            this.buttonBar.addSeparator();
            this.buttonBar.add(jButton2);
            this.buttonBar.add(this.renameButton);
            this.buttonBar.add(this.deleteButton);
        }
        return this.buttonBar;
    }

    protected JButton getDeleteButton() {
        return this.deleteButton;
    }

    public JTextField getDirTextField() {
        return this.dirTextField;
    }

    protected JButton getDownloadButton() {
        return this.downloadButton;
    }

    protected JProgressBar getProgressBar() {
        return this.statusPanel.getProgressBar();
    }

    protected JButton getRenameButton() {
        return this.renameButton;
    }

    protected ServerListPanel getServerPanel() {
        return this.serverPanel;
    }

    protected StatusPanel getStatusPanel() {
        return this.statusPanel;
    }

    protected JButton getStopButton() {
        return this.stopButton;
    }

    protected void setConnectionColor(Color color) {
        this.colorPanel.setBackground(color);
    }

    protected void setStatus(String string) {
        this.setStatus(string, 2);
    }

    protected void setStatus(String string, int n2) {
        this.statusPanel.setStatus(string);
        if (n2 > 0) {
            this.delayedStatusReset(n2);
        }
    }
}

