/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class SecureFtpToolBar
extends JToolBar
implements Constants {
    private SecureFtpApplet parent;
    private JButton connectButton;
    private JButton disconnectButton;
    private JButton logButton;
    private JButton helpButton;
    private JToggleButton autoButton;
    private JToggleButton asciiButton;
    private JToggleButton binaryButton;
    private ActionListener autoListener;
    private ActionListener asciiListener;
    private ActionListener binaryListener;
    private Vector modeItemVector = new Vector();
    private Vector modeActionVector = new Vector();
    private ButtonGroup modeGroup = new ButtonGroup();

    public SecureFtpToolBar(SecureFtpApplet secureFtpApplet) {
        this.parent = secureFtpApplet;
        this.getToolBar();
        this.setOrientation(0);
        this.setFloatable(false);
        this.setModeFromPrefs(this.parent.getPrefs().getTransferMode());
        this.openConnectionTB();
    }

    protected void closeConnectionTB() {
        this.connectButton.setEnabled(false);
        this.disconnectButton.setEnabled(true);
    }

    protected void disableConnectionTB() {
        this.connectButton.setEnabled(false);
        this.disconnectButton.setEnabled(false);
    }

    private void getToolBar() {
        String[] stringArray = new String[]{new LString("toolbar.connect.label", "Connect").getString(), new LString("toolbar.disconnect.label", "Disconnect").getString(), new LString("toolbar.auto_transfer.label", "Auto Transfer Mode").getString(), new LString("toolbar.binary_transfer.label", "Binary Transfer Mode").getString(), new LString("toolbar.ascii_transfer.label", "Text (Ascii) Transfer Mode").getString(), new LString("toolbar.session.label", "Session Log").getString(), new LString("toolbar.help.label", "Help").getString()};
        ImageIcon[] imageIconArray = new ImageIcon[]{new ImageIcon(this.getClass().getResource("images/connect.gif")), new ImageIcon(this.getClass().getResource("images/disconnect.gif")), new ImageIcon(this.getClass().getResource("images/auto.gif")), new ImageIcon(this.getClass().getResource("images/binary.gif")), new ImageIcon(this.getClass().getResource("images/ascii.gif")), new ImageIcon(this.getClass().getResource("images/log.gif")), new ImageIcon(this.getClass().getResource("images/help.gif"))};
        this.connectButton = new JButton(imageIconArray[0]);
        this.connectButton.setToolTipText(stringArray[0]);
        this.disconnectButton = new JButton(imageIconArray[1]);
        this.disconnectButton.setToolTipText(stringArray[1]);
        this.autoButton = new JToggleButton(imageIconArray[2]);
        this.autoButton.setMaximumSize(new Dimension(31, 31));
        this.autoButton.setToolTipText(stringArray[2]);
        this.binaryButton = new JToggleButton(imageIconArray[3]);
        this.binaryButton.setMaximumSize(new Dimension(31, 31));
        this.binaryButton.setToolTipText(stringArray[3]);
        this.asciiButton = new JToggleButton(imageIconArray[4]);
        this.asciiButton.setMaximumSize(new Dimension(31, 31));
        this.asciiButton.setToolTipText(stringArray[4]);
        this.logButton = new JButton(imageIconArray[5]);
        this.logButton.setToolTipText(stringArray[5]);
        this.helpButton = new JButton(imageIconArray[6]);
        this.helpButton.setToolTipText(stringArray[6]);
        this.addSeparator();
        this.add(this.connectButton);
        this.add(this.disconnectButton);
        this.addSeparator();
        this.add(this.autoButton);
        this.add(this.binaryButton);
        this.add(this.asciiButton);
        this.addSeparator();
        this.add(this.logButton);
        this.addSeparator();
        this.add(this.helpButton);
        this.modeGroup.add(this.autoButton);
        this.modeGroup.add(this.binaryButton);
        this.modeGroup.add(this.asciiButton);
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getServerUtil().openConnectionDialog();
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        });
        this.disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getServerUtil().closeConnection();
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        });
        this.autoListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getServerUtil().setMode("U");
                if (SecureFtpToolBar.this.parent.getMenuBar() != null) {
                    SecureFtpToolBar.this.parent.getMenuBar().setMode(0);
                }
                SecureFtpToolBar.this.writeModePrefs(0);
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        };
        this.autoButton.addActionListener(this.autoListener);
        this.binaryListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getServerUtil().setMode("B");
                if (SecureFtpToolBar.this.parent.getMenuBar() != null) {
                    SecureFtpToolBar.this.parent.getMenuBar().setMode(1);
                }
                SecureFtpToolBar.this.writeModePrefs(1);
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        };
        this.binaryButton.addActionListener(this.binaryListener);
        this.asciiListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getServerUtil().setMode("A");
                if (SecureFtpToolBar.this.parent.getMenuBar() != null) {
                    SecureFtpToolBar.this.parent.getMenuBar().setMode(2);
                }
                SecureFtpToolBar.this.writeModePrefs(2);
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        };
        this.asciiButton.addActionListener(this.asciiListener);
        this.logButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.getSessionLoggingFrame().setVisible(true);
                SecureFtpToolBar.this.parent.getSessionLoggingFrame().getScrollPane().revalidate();
                SecureFtpToolBar.this.parent.getDesktopPane().revalidate();
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        });
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SecureFtpToolBar.this.parent.displayHelp();
                SecureFtpToolBar.this.parent.getDesktopPane().requestFocus();
            }
        });
        this.modeItemVector.addElement(this.autoButton);
        this.modeItemVector.addElement(this.binaryButton);
        this.modeItemVector.addElement(this.asciiButton);
        this.modeActionVector.addElement(this.autoListener);
        this.modeActionVector.addElement(this.binaryListener);
        this.modeActionVector.addElement(this.asciiListener);
    }

    protected void openConnectionTB() {
        this.connectButton.setEnabled(true);
        this.disconnectButton.setEnabled(false);
    }

    protected void setMode(int n2) {
        ((JToggleButton)this.modeItemVector.elementAt(n2)).setSelected(true);
    }

    protected void setModeFromPrefs(int n2) {
        ((JToggleButton)this.modeItemVector.elementAt(n2)).setSelected(true);
        ((ActionListener)this.modeActionVector.elementAt(n2)).actionPerformed(new ActionEvent(this, 1001, "preference"));
    }

    private void writeModePrefs(int n2) {
        this.parent.getPrefs().setTransferMode(n2);
        try {
            this.parent.getPrefs().writePreferences();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_write_prefs.msg", "Failed to write preferences").getString());
        }
    }
}

