/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Preferences;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpGui;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;

public class SecureFtpApplication
extends JFrame
implements Constants {
    private SecureFtpGui parent;
    private Preferences prefs;

    public SecureFtpApplication(SecureFtpGui secureFtpGui) {
        this.parent = secureFtpGui;
        this.prefs = this.parent.getApplet().getPrefs();
        boolean bl2 = false;
        if (this.prefs.getWidth() < 625) {
            debug.println("current width is smaller than default");
            this.prefs.setWidth(625);
            this.prefs.setInternalWidth(302);
            bl2 = true;
        }
        if (this.prefs.getHeight() < 500) {
            debug.println("current height is smaller than default");
            this.prefs.setHeight(500);
            this.prefs.setInternalHeight(400);
            bl2 = true;
        }
        if (bl2) {
            try {
                this.prefs.writePreferences();
            }
            catch (Exception exception) {
                new ErrorDialog(exception.getMessage(), new LString("failed_to_write_prefs.msg", "Failed to write preferences.").getString());
            }
        }
        this.setName("main_frame");
        this.setTitle("Secure FTP");
        ((Component)this).setSize(this.prefs.getWidth(), this.prefs.getHeight());
        ((Frame)this).setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/frame_lock.gif")));
        debug.println("width = " + this.prefs.getWidth() + " height = " + this.prefs.getHeight());
        this.position();
        this.parent.getApplet().setApp(true);
        this.parent.getApplet().setAppFrame(this);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                if (SecureFtpApplication.this.parent.getApplet().getFtpNet() != null && SecureFtpApplication.this.parent.getApplet().getFtpNet().isConnected()) {
                    SecureFtpApplication.this.parent.getApplet().getFtpNet().disconnect();
                }
                SecureFtpApplication.this.parent.getApplet().savePrefs();
                System.exit(0);
            }
        });
    }

    private void position() {
        ((Component)this).setLocation((this.getToolkit().getScreenSize().width - this.getSize().width) / 2, (this.getToolkit().getScreenSize().height - this.getSize().height) / 3);
    }
}

