/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ConnectionInfoDialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.MakingConnectionDialog;
import edu.sdsc.secureftp.gui.OpenConnection;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class OpenConnectionDialog
extends ConnectionInfoDialog
implements Constants {
    private JPasswordField passwordField;
    private String oldPassword;
    private JCheckBox bookmarkCheckBox;
    private JButton connectButton;
    private JButton cancelButton;
    private OpenConnection connectionThread;
    private MakingConnectionDialog cancelDialog;

    public OpenConnectionDialog(SecureFtpApplet secureFtpApplet) {
        super(secureFtpApplet, new LString("open_connection.title", "Open connection").getString(), true);
    }

    private void addBookmark() {
        Bookmark bookmark = new Bookmark(this.getHostNameTextField().getText(), this.getHostNameTextField().getText(), this.getPortTextField().getText(), this.getUserNameTextField().getText(), null, this.getSecurityChoice().getSelectedIndex(), this.getPasvCheckBox().isSelected(), this.getAnonCheckBox().isSelected(), this.getProxyCheckBox().isSelected(), this.getEncryptionCheckBox().isSelected(), null, null);
        this.parent.getBookmarks().addElement(bookmark);
        this.parent.getMenuBar().addBookmark(bookmark);
        try {
            this.parent.getBookmarks().writeToDisk();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_write_bookmarks.msg", "Failed to write bookmarks.").getString());
        }
    }

    protected void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.connectButton);
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!OpenConnectionDialog.this.hostNameTextField.getText().trim().equals("")) {
                    OpenConnectionDialog.this.makeConnection();
                    OpenConnectionDialog.this.dispose();
                } else {
                    OpenConnectionDialog.this.getToolkit().beep();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("cancelling connection", 3);
                OpenConnectionDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!OpenConnectionDialog.this.hostNameTextField.getText().trim().equals("")) {
                        OpenConnectionDialog.this.makeConnection();
                        OpenConnectionDialog.this.dispose();
                    } else {
                        OpenConnectionDialog.this.getToolkit().beep();
                    }
                } else if (keyEvent.getKeyCode() == 27) {
                    OpenConnectionDialog.this.dispose();
                }
            }
        });
    }

    protected void addButtons() {
        if (this.connectButton == null) {
            this.connectButton = new JButton(new LString("toolbar.connect.label", "Connect").getString());
        }
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
        }
        this.buttonPanel.add(this.connectButton);
        this.buttonPanel.add(this.cancelButton);
    }

    protected JCheckBox getAnonCheckBox() {
        if (this.anonCheckBox == null) {
            this.anonCheckBox = new JCheckBox(" " + new LString("connection_info.anonymous.label", "Anonymous").getString() + " ", false);
            this.anonCheckBox.setFont(new Font("Dialog", 0, 10));
            this.anonCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (OpenConnectionDialog.this.anonCheckBox.isSelected()) {
                        OpenConnectionDialog.this.oldUserName = OpenConnectionDialog.this.getUserNameTextField().getText();
                        OpenConnectionDialog.this.oldPassword = new String(OpenConnectionDialog.this.getPasswordField().getPassword());
                        OpenConnectionDialog.this.oldSecurityChoice = OpenConnectionDialog.this.getSecurityChoice().getSelectedIndex();
                        OpenConnectionDialog.this.getUserNameTextField().setText("anonymous");
                        ((JTextComponent)OpenConnectionDialog.this.getPasswordField()).setText("secureftp@");
                        OpenConnectionDialog.this.getSecurityChoice().setSelectedIndex(0);
                    } else {
                        OpenConnectionDialog.this.getUserNameTextField().setText(OpenConnectionDialog.this.oldUserName);
                        ((JTextComponent)OpenConnectionDialog.this.getPasswordField()).setText(OpenConnectionDialog.this.oldPassword);
                        OpenConnectionDialog.this.getSecurityChoice().setSelectedIndex(OpenConnectionDialog.this.oldSecurityChoice);
                    }
                }
            });
        }
        return this.anonCheckBox;
    }

    protected JCheckBox getBookmarkCheckBox() {
        if (this.bookmarkCheckBox == null) {
            this.bookmarkCheckBox = new JCheckBox(" " + new LString("open_connection.save_bookmark.label", "Save to Bookmarks").getString() + " ", false);
            this.bookmarkCheckBox.setFont(new Font("Dialog", 0, 10));
        }
        return this.bookmarkCheckBox;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            JLabel jLabel;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setPreferredSize(new Dimension(300, 180));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = new LString("connection_info.hostname.label", "Hostname").getString();
            String string2 = new LString("connection_info.username.label", "Username").getString();
            String string3 = new LString("open_connection.password.label", "Password").getString();
            boolean bl2 = false;
            int n2 = this.getFont().getSize();
            while (!bl2 && n2 >= 8) {
                jLabel = new JLabel("");
                this.setFont(new Font(jLabel.getFont().getFontName(), jLabel.getFont().getStyle(), n2));
                fontMetrics = this.getFontMetrics(this.getFont());
                int n3 = fontMetrics.stringWidth(string);
                int n4 = fontMetrics.stringWidth(string2);
                int n5 = fontMetrics.stringWidth(string3);
                if (n3 < 102 && n4 < 102 && n5 < 102) {
                    bl2 = true;
                }
                --n2;
            }
            jLabel = new JLabel("  " + string + ":");
            jLabel.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel, this.getGBC(0, 16, 0.3, 1.0, 0, 0, 1, 2));
            this.mainPanel.add((Component)this.getHostNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 1, 4, 1));
            JLabel jLabel2 = new JLabel("  " + string2 + ":");
            jLabel2.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel2, this.getGBC(0, 16, 0.3, 1.0, 0, 2, 1, 2));
            this.mainPanel.add((Component)this.getUserNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 3, 4, 1));
            JLabel jLabel3 = new JLabel("  " + string3 + ":");
            jLabel3.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel3, this.getGBC(0, 17, 0.3, 1.0, 0, 4, 1, 2));
            this.mainPanel.add((Component)this.getPasswordField(), this.getGBC(0, 17, 0.7, 0.0, 1, 5, 4, 1));
            this.mainPanel.add((Component)this.getAnonCheckBox(), this.getGBC(0, 17, 0.3, 1.0, 1, 6, 1, 1));
            this.mainPanel.add((Component)this.getBookmarkCheckBox(), this.getGBC(0, 18, 0.3, 1.0, 1, 7, 1, 1));
        }
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    OpenConnectionDialog.this.getHostNameTextField().requestFocus();
                    OpenConnectionDialog.this.setResizable(false);
                }
            });
        }
        return this.mainPanel;
    }

    protected JPasswordField getPasswordField() {
        if (this.passwordField == null) {
            this.passwordField = new JPasswordField(15);
            this.passwordField.setEchoChar('*');
            this.unSetEnterEvent(this.passwordField);
        }
        return this.passwordField;
    }

    protected void makeConnection() {
        if (this.hostNameTextField.getText().trim().equals("")) {
            debug.println("OpenConnection: hostname not entered", 1);
            return;
        }
        if (this.getBookmarkCheckBox().isSelected()) {
            this.addBookmark();
        }
        this.cancelDialog = new MakingConnectionDialog(this.parent, this);
        this.connectionThread = new OpenConnection(this.parent, this.cancelDialog, this.getHostNameTextField().getText().trim(), this.getPortTextField().getText().trim(), this.getUserNameTextField().getText().trim(), new String(this.getPasswordField().getPassword()), this.getSecurityChoice().getSelectedIndex(), new String((String)this.securityChoice.getSelectedItem()), this.getPasvCheckBox().isSelected(), this.getAnonCheckBox().isSelected(), this.getProxyCheckBox().isSelected(), this.getEncryptionCheckBox().isSelected(), null, null);
        this.connectionThread.start();
    }

    protected void stopConnection() {
        debug.println("killing connection thread", 2);
        this.cancelDialog.getProgressBar().setValue(this.cancelDialog.getProgressBar().getMaximum());
        if (this.parent.getFtpNet() != null && this.parent.getFtpNet().isConnected()) {
            this.parent.getFtpNet().disconnect();
        }
        this.parent.getServerUtil().enableOpenConnectionItems();
        this.connectionThread.stop();
    }
}

