/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Data;
import edu.sdsc.secureftp.data.FtpKeyStore;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.SecurityInfoDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.security.cert.X509Certificate;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class NewCertificateDialog
extends SecurityInfoDialog
implements Constants {
    private JButton acceptButton;
    private JButton oneTimeButton;
    private JButton rejectButton;
    private transient boolean status;

    public NewCertificateDialog(SecureFtpApplet secureFtpApplet, String string, boolean bl2) {
        super(secureFtpApplet, string, bl2);
    }

    static /* synthetic */ boolean access$1(NewCertificateDialog newCertificateDialog) {
        return newCertificateDialog.status;
    }

    protected void addButtonListeners() {
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("add certificate to keystore");
                Data data = NewCertificateDialog.this.parent.getLocalData();
                NewCertificateDialog.this.writeNewCert(data.getCertificate(), data.getFtpKeyStore());
                NewCertificateDialog.this.status = true;
                NewCertificateDialog.this.dispose();
            }
        });
        this.oneTimeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("allow connection, but don't add to keystore");
                NewCertificateDialog.this.status = true;
                NewCertificateDialog.this.dispose();
            }
        });
        this.rejectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debug.println("stop connection");
                NewCertificateDialog.this.status = false;
                NewCertificateDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    debug.println("allow connection, but don't add to keystore");
                    NewCertificateDialog.this.status = true;
                    NewCertificateDialog.this.dispose();
                }
                if (keyEvent.getKeyCode() == 27) {
                    debug.println("stop connection");
                    NewCertificateDialog.this.status = false;
                    NewCertificateDialog.this.dispose();
                }
            }
        });
    }

    protected void getButtons() {
        if (this.oneTimeButton == null) {
            this.oneTimeButton = new JButton(new LString("grant_this_session.label", "Grant This Session").getString());
        }
        if (this.rejectButton == null) {
            this.rejectButton = new JButton(new LString("deny_session.label", "Deny").getString());
        }
        if (this.acceptButton == null) {
            this.acceptButton = new JButton(new LString("grant_always.label", "Grant Always").getString());
        }
        this.buttonPanel.add(this.oneTimeButton);
        this.buttonPanel.add(this.rejectButton);
        this.buttonPanel.add(this.acceptButton);
        SwingUtilities.getRootPane(this).setDefaultButton(this.oneTimeButton);
    }

    protected boolean getStatus() {
        return this.status;
    }

    public static boolean processCertificate(SecureFtpApplet secureFtpApplet) {
        return NewCertificateDialog.processCertificate(secureFtpApplet, new LString("new_cert_found.title", "New certificate encountered").getString());
    }

    public static boolean processCertificate(SecureFtpApplet secureFtpApplet, String string) {
        NewCertificateDialog newCertificateDialog = new NewCertificateDialog(secureFtpApplet, string, true);
        boolean bl2 = newCertificateDialog.getStatus();
        return bl2;
    }

    private void writeNewCert(X509Certificate x509Certificate, FtpKeyStore ftpKeyStore) {
        LString lString = new LString("replace_cert.msg", "A certificate with the same name exists.\nReplace it?");
        if (ftpKeyStore.lookupAlias(x509Certificate)) {
            int n2 = JOptionPane.showConfirmDialog(null, lString.getString(), new LString("replace_cert.title", "Replace certificate").getString(), 0);
            if (n2 != 0) {
                return;
            }
            ftpKeyStore.removeCertificate(x509Certificate);
        }
        ftpKeyStore.addCertificate(x509Certificate);
        ftpKeyStore.writeKeyStore();
    }
}

