/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.LocalListThread;
import edu.sdsc.secureftp.gui.LocalStatusThread;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import javax.swing.JButton;

public class LocalUtil {
    private SecureFtpApplet gui;
    private LocalListThread listThread;
    private boolean stopListThread;

    public LocalUtil(SecureFtpApplet secureFtpApplet) {
        this.gui = secureFtpApplet;
        this.listThread = null;
    }

    public boolean cdup() {
        File file = new File(this.getDirName());
        String string = file.getParent();
        if (string == null) {
            return false;
        }
        this.changeDir(string);
        return true;
    }

    public void changeDir(String string) {
        this.chdir(string);
        this.list();
        this.gui.getLocalFrame().getDirTextField().setText(this.getDirName());
        debug.println("LocalUtil: local change dir to: " + string, 5);
        debug.println("LocalUtil: current local dir: " + this.getDirName(), 4);
    }

    public void chdir(String string) {
        File file = new File(string);
        try {
            System.setProperty("user.dir", file.getCanonicalPath());
        }
        catch (IOException iOException) {
            this.gui.getLocalFrame().setStatus(new LString("change_dir_failed.msg", "Change directory failed").getString());
        }
    }

    public boolean delete(String string) {
        File file = new File(string).getAbsoluteFile();
        if (string.equals(".") || string.equals("..")) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        try {
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                int n2 = 0;
                while (n2 < stringArray.length) {
                    this.delete(String.valueOf(file.getAbsolutePath()) + File.separator + stringArray[n2]);
                    ++n2;
                }
                return file.delete();
            }
            return file.delete();
        }
        catch (SecurityException securityException) {
            new ErrorDialog(securityException.getMessage(), new LString("delete_failed.title", "Delete failed").getString());
            return false;
        }
    }

    public boolean delete(FileEntry[] fileEntryArray) {
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < fileEntryArray.length) {
            bl2 = bl2 && this.delete(fileEntryArray[n2].getName());
            ++n2;
        }
        return bl2;
    }

    protected void disableButtonBar() {
        this.getDeleteButton().setEnabled(true);
        this.getRenameButton().setEnabled(true);
    }

    protected void enableButtonBar() {
        this.getDeleteButton().setEnabled(true);
        this.getRenameButton().setEnabled(true);
    }

    private JButton getDeleteButton() {
        return this.gui.getLocalFrame().getDeleteButton();
    }

    public String getDirName() {
        return System.getProperty("user.dir");
    }

    private JButton getRenameButton() {
        return this.gui.getLocalFrame().getRenameButton();
    }

    private JButton getUploadButton() {
        return this.gui.getLocalFrame().getUploadButton();
    }

    public synchronized void list() {
        if (this.listThread != null && this.listThread.isAlive()) {
            this.stopList(false);
            try {
                this.listThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stopListThread = false;
        this.listThread = new LocalListThread(this);
        this.listThread.start();
    }

    public boolean mkdir(File file) {
        try {
            return file.mkdir();
        }
        catch (SecurityException securityException) {
            new ErrorDialog(securityException.getMessage(), new LString("create_dir_failed.title", "Create directory failed").getString());
            return false;
        }
    }

    public boolean mkdir(String string) {
        return this.mkdir(new File(string).getAbsoluteFile());
    }

    public boolean rename(String string, String string2) {
        File file = new File(string).getAbsoluteFile();
        File file2 = new File(string2).getAbsoluteFile();
        try {
            return file.renameTo(file2);
        }
        catch (SecurityException securityException) {
            new ErrorDialog(securityException.getMessage(), new LString("rename_failed.title", "Rename failed").getString());
            return false;
        }
    }

    protected void runListThread() {
        Object[] objectArray;
        this.gui.getLocalFrame().getStopButton().setEnabled(true);
        this.gui.getLocalPanel().clearSelections();
        this.gui.getLocalPanel().removeAllRows();
        File file = new File(this.getDirName());
        try {
            objectArray = file.listFiles();
            if (objectArray == null) {
                this.gui.getLocalFrame().setStatus(new LString("listing_failed.msg", "Listing failed.").getString());
                return;
            }
        }
        catch (SecurityException securityException) {
            return;
        }
        LocalStatusThread localStatusThread = new LocalStatusThread(this.gui, this.gui.getLocalFrame().getStatusPanel(), objectArray.length, new LString("listing_dir.msg", "Listing directory").getString());
        localStatusThread.start();
        Arrays.sort(objectArray);
        int n2 = 0;
        while (n2 < objectArray.length && !this.stopListThread) {
            Date date = new Date(((File)objectArray[n2]).lastModified());
            DateFormat dateFormat = DateFormat.getDateInstance(2);
            this.gui.getLocalPanel().buildRow(((File)objectArray[n2]).isDirectory() ? "d" : "f", ((File)objectArray[n2]).getName(), Long.toString(((File)objectArray[n2]).length()), dateFormat.format(date));
            ++n2;
        }
        this.gui.getLocalFrame().getStopButton().setEnabled(false);
        localStatusThread.done();
        this.gui.getLocalPanel().repaint();
    }

    protected synchronized void stopList() {
        this.stopList(true);
    }

    protected synchronized void stopList(boolean bl2) {
        debug.println("listing stopped", 3);
        if (bl2) {
            this.gui.getLocalFrame().setStatus(new LString("listing_cancelled.msg", "Listing cancelled.").getString());
        }
        this.stopListThread = true;
    }

    protected void stopListThread() {
        this.listThread.stop();
    }
}

