/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.BasicFtp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Keymap;

public class ConnectionInfoDialog
extends JDialog
implements Constants {
    protected SecureFtpApplet parent;
    protected JTabbedPane tabPane = new JTabbedPane();
    protected JPanel mainPanel = null;
    protected JTextField hostNameTextField = null;
    protected JTextField userNameTextField = null;
    protected String oldUserName = null;
    protected JCheckBox anonCheckBox = null;
    protected JPanel securityPanel = null;
    protected JComboBox securityChoice = null;
    protected int oldSecurityChoice;
    protected JTextField portTextField = null;
    protected JPanel advancedPanel = null;
    protected JCheckBox pasvCheckBox = null;
    protected JCheckBox proxyCheckBox = null;
    protected JCheckBox encryptionCheckBox = null;
    protected boolean oldEncryptionState = false;
    protected JPanel buttonPanel;
    protected Bookmark bookmark;
    protected GridBagConstraints gbc = new GridBagConstraints();

    public ConnectionInfoDialog(SecureFtpApplet secureFtpApplet, Bookmark bookmark, String string, boolean bl2) {
        super(secureFtpApplet.getBaseFrame(), string, bl2);
        this.parent = secureFtpApplet;
        this.bookmark = bookmark;
        this.construct();
    }

    public ConnectionInfoDialog(SecureFtpApplet secureFtpApplet, String string, boolean bl2) {
        super(secureFtpApplet.getBaseFrame(), string, bl2);
        this.parent = secureFtpApplet;
        this.construct();
    }

    protected void addButtonListeners() {
    }

    protected void addButtons() {
    }

    public void addNotify() {
        super.addNotify();
        this.getHostNameTextField().requestFocus();
    }

    private void construct() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.tabPane, "Center");
        this.buttonPanel = new JPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        String string = new LString("connection_info.connection.label", "Connection").getString();
        String string2 = new LString("connection_info.security.label", "Security").getString();
        String string3 = new LString("connection_info.advanced.label", "Advanced").getString();
        boolean bl2 = false;
        int n2 = this.tabPane.getFont().getSize();
        while (!bl2 && n2 >= 8) {
            JLabel jLabel = new JLabel("");
            this.tabPane.setFont(new Font(jLabel.getFont().getFontName(), jLabel.getFont().getStyle(), n2));
            fontMetrics = this.getFontMetrics(this.tabPane.getFont());
            int n3 = fontMetrics.stringWidth(string);
            int n4 = fontMetrics.stringWidth(string2);
            int n5 = fontMetrics.stringWidth(string3);
            if (n3 < 75 && n4 < 75 && n5 < 75) {
                bl2 = true;
            }
            --n2;
        }
        this.tabPane.add((Component)this.getMainPanel(), string);
        this.tabPane.add((Component)this.getSecurityPanel(), string2);
        this.tabPane.add((Component)this.getAdvancedPanel(), string3);
        this.setupDefaults();
        this.buttonPanel.setLayout(new FlowLayout());
        this.addButtons();
        this.addButtonListeners();
        this.pack();
        this.setLocationRelativeTo(this.parent.getContentPane());
        this.tabPane.setRequestFocusEnabled(false);
        ((Component)this).setVisible(true);
    }

    protected JPanel getAdvancedPanel() {
        if (this.advancedPanel == null) {
            this.advancedPanel = new JPanel();
            this.advancedPanel.setLayout(new GridBagLayout());
            this.advancedPanel.setPreferredSize(new Dimension(300, 180));
            this.advancedPanel.add((Component)new JLabel("  " + new LString("connection_info.port.label", "Port").getString() + ":"), this.getGBC(0, 17, 0.3, 1.0, 0, 0, 1, 2));
            this.advancedPanel.add((Component)this.getPortTextField(), this.getGBC(0, 17, 0.7, 0.0, 1, 1, 4, 1));
            this.advancedPanel.add((Component)new JLabel("  PASV:"), this.getGBC(0, 17, 0.3, 1.0, 0, 2, 1, 2));
            this.advancedPanel.add((Component)this.getPasvCheckBox(), this.getGBC(0, 17, 0.7, 0.0, 1, 3, 4, 1));
            this.advancedPanel.add((Component)new JLabel("  " + new LString("connection_info.proxy.label", "Use Proxy").getString() + ":"), this.getGBC(0, 17, 0.3, 1.0, 0, 4, 1, 2));
            this.advancedPanel.add((Component)this.getProxyCheckBox(), this.getGBC(0, 17, 0.7, 0.0, 1, 5, 4, 1));
        }
        return this.advancedPanel;
    }

    protected JCheckBox getAnonCheckBox() {
        if (this.anonCheckBox == null) {
            this.anonCheckBox = new JCheckBox(" " + new LString("connection_info.anonymous.label", "Anonymous").getString() + " ", false);
            this.anonCheckBox.setFont(new Font("Dialog", 0, 10));
            this.anonCheckBox.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (ConnectionInfoDialog.this.anonCheckBox.isSelected()) {
                        ConnectionInfoDialog.this.oldUserName = ConnectionInfoDialog.this.getUserNameTextField().getText();
                        ConnectionInfoDialog.this.oldSecurityChoice = ConnectionInfoDialog.this.getSecurityChoice().getSelectedIndex();
                        ConnectionInfoDialog.this.getUserNameTextField().setText("anonymous");
                        ConnectionInfoDialog.this.getSecurityChoice().setSelectedIndex(0);
                    } else {
                        ConnectionInfoDialog.this.getUserNameTextField().setText(ConnectionInfoDialog.this.oldUserName);
                        ConnectionInfoDialog.this.getSecurityChoice().setSelectedIndex(ConnectionInfoDialog.this.oldSecurityChoice);
                    }
                }
            });
        }
        return this.anonCheckBox;
    }

    protected JCheckBox getEncryptionCheckBox() {
        if (this.encryptionCheckBox == null) {
            this.encryptionCheckBox = new JCheckBox("", false);
        }
        return this.encryptionCheckBox;
    }

    protected GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    protected JTextField getHostNameTextField() {
        if (this.hostNameTextField == null) {
            this.hostNameTextField = new JTextField(15);
            this.unSetEnterEvent(this.hostNameTextField);
        }
        return this.hostNameTextField;
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setPreferredSize(new Dimension(300, 180));
            this.mainPanel.add((Component)new JLabel("  " + new LString("connection_info.hostname.label", "Hostname").getString() + ":"), this.getGBC(0, 16, 0.3, 1.0, 0, 0, 1, 2));
            this.mainPanel.add((Component)this.getHostNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 1, 4, 1));
            this.mainPanel.add((Component)new JLabel("  " + new LString("connection_info.username.label", "Username").getString() + ":"), this.getGBC(0, 16, 0.3, 1.0, 0, 2, 1, 2));
            this.mainPanel.add((Component)this.getUserNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 3, 4, 1));
            this.mainPanel.add((Component)this.getAnonCheckBox(), this.getGBC(0, 17, 0.3, 1.0, 1, 4, 1, 1));
        }
        return this.mainPanel;
    }

    protected JCheckBox getPasvCheckBox() {
        if (this.pasvCheckBox == null) {
            this.pasvCheckBox = new JCheckBox("", true);
        }
        return this.pasvCheckBox;
    }

    protected JTextField getPortTextField() {
        if (this.portTextField == null) {
            this.portTextField = new JTextField(5);
            this.portTextField.setText(Integer.toString(((BasicFtp)this.parent.securityVector.elementAt(1)).getDefaultPort()));
            this.unSetEnterEvent(this.portTextField);
        }
        return this.portTextField;
    }

    protected JCheckBox getProxyCheckBox() {
        if (this.proxyCheckBox == null) {
            this.proxyCheckBox = new JCheckBox("");
            if (this.parent.getServerUtil().getSocksProxyHost() != null && this.parent.getServerUtil().getSocksProxyPort() != null) {
                this.proxyCheckBox.setEnabled(true);
                this.proxyCheckBox.setSelected(true);
            } else {
                this.proxyCheckBox.setEnabled(false);
            }
        }
        return this.proxyCheckBox;
    }

    protected JComboBox getSecurityChoice() {
        if (this.securityChoice == null) {
            this.securityChoice = new JComboBox();
            int n2 = 0;
            while (n2 < this.parent.securityVector.size()) {
                this.securityChoice.addItem(((BasicFtp)this.parent.securityVector.elementAt(n2)).getSecurityType());
                ++n2;
            }
            this.securityChoice.setSelectedIndex(1);
            this.securityChoice.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    int n2 = ConnectionInfoDialog.this.securityChoice.getSelectedIndex();
                    ConnectionInfoDialog.this.portTextField.setText(Integer.toString(((BasicFtp)ConnectionInfoDialog.this.parent.securityVector.elementAt(n2)).getDefaultPort()));
                    if (ConnectionInfoDialog.this.getEncryptionCheckBox().isEnabled() && n2 == 0) {
                        ConnectionInfoDialog.this.oldEncryptionState = ConnectionInfoDialog.this.getEncryptionCheckBox().isSelected();
                        ConnectionInfoDialog.this.getEncryptionCheckBox().setSelected(false);
                        ConnectionInfoDialog.this.getEncryptionCheckBox().setEnabled(false);
                    } else if (n2 != 0) {
                        ConnectionInfoDialog.this.getEncryptionCheckBox().setSelected(ConnectionInfoDialog.this.oldEncryptionState);
                        ConnectionInfoDialog.this.getEncryptionCheckBox().setEnabled(true);
                    }
                }
            });
        }
        return this.securityChoice;
    }

    protected JPanel getSecurityPanel() {
        if (this.securityPanel == null) {
            this.securityPanel = new JPanel();
            this.securityPanel.setLayout(new GridBagLayout());
            this.securityPanel.setPreferredSize(new Dimension(300, 180));
            this.securityPanel.add((Component)new JLabel("  " + new LString("connection_info.security.label", "Security").getString() + ":"), this.getGBC(0, 17, 0.3, 1.0, 0, 0, 1, 2));
            this.securityPanel.add((Component)this.getSecurityChoice(), this.getGBC(0, 17, 0.7, 0.0, 1, 1, 4, 1));
            this.securityPanel.add((Component)new JLabel("  " + new LString("connection_info.data_encryption.label", "Data Encryption").getString() + ":"), this.getGBC(0, 18, 0.3, 1.0, 0, 2, 1, 2));
            this.securityPanel.add((Component)this.getEncryptionCheckBox(), this.getGBC(0, 18, 0.7, 0.0, 1, 3, 4, 1));
        }
        return this.securityPanel;
    }

    protected JTextField getUserNameTextField() {
        if (this.userNameTextField == null) {
            this.userNameTextField = new JTextField(15);
            this.userNameTextField.setText(System.getProperty("user.name"));
            this.unSetEnterEvent(this.userNameTextField);
        }
        return this.userNameTextField;
    }

    protected void setupDefaults() {
    }

    protected void unSetEnterEvent(JTextField jTextField) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        Keymap keymap = jTextField.getKeymap();
        keymap.removeKeyStrokeBinding(keyStroke);
    }
}

