/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.Bookmark;
import edu.sdsc.secureftp.gui.ConnectionInfoDialog;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class AddBookmarkDialog
extends ConnectionInfoDialog
implements Constants {
    private JTextField profileNameTextField;
    private JButton addButton;
    private JButton cancelButton;

    public AddBookmarkDialog(SecureFtpApplet secureFtpApplet) {
        super(secureFtpApplet, new LString("add_bookmark.title", "Add Bookmark").getString(), true);
        this.setResizable(false);
    }

    private void addBookmark() {
        Bookmark bookmark = new Bookmark(this.getProfileNameTextField().getText(), this.getHostNameTextField().getText(), this.getPortTextField().getText(), this.getUserNameTextField().getText(), null, this.getSecurityChoice().getSelectedIndex(), this.getPasvCheckBox().isSelected(), this.getAnonCheckBox().isSelected(), this.getProxyCheckBox().isSelected(), this.getEncryptionCheckBox().isSelected(), null, null);
        this.parent.getBookmarks().addBookmark(bookmark);
        this.parent.getMenuBar().addBookmark(bookmark);
        try {
            this.parent.getBookmarks().writeToDisk();
        }
        catch (Exception exception) {
            new ErrorDialog(exception.getMessage(), new LString("failed_to_write_bookmarks.msg", "Failed to write bookmarks").getString());
        }
    }

    protected void addButtonListeners() {
        SwingUtilities.getRootPane(this).setDefaultButton(this.addButton);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AddBookmarkDialog.this.profileNameTextField.getText().trim().equals("") && !AddBookmarkDialog.this.hostNameTextField.getText().trim().equals("")) {
                    AddBookmarkDialog.this.addBookmark();
                    AddBookmarkDialog.this.dispose();
                } else {
                    AddBookmarkDialog.this.getToolkit().beep();
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddBookmarkDialog.this.dispose();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    if (!AddBookmarkDialog.this.profileNameTextField.getText().trim().equals("") && !AddBookmarkDialog.this.hostNameTextField.getText().trim().equals("")) {
                        AddBookmarkDialog.this.addBookmark();
                        AddBookmarkDialog.this.dispose();
                    } else {
                        AddBookmarkDialog.this.getToolkit().beep();
                    }
                } else if (keyEvent.getKeyCode() == 27) {
                    AddBookmarkDialog.this.dispose();
                }
            }
        });
    }

    protected void addButtons() {
        if (this.addButton == null) {
            this.addButton = new JButton(new LString("add_bookmark.add_button.label", "Add").getString());
        }
        if (this.cancelButton == null) {
            this.cancelButton = new JButton(new LString("cancel_button.label", "Cancel").getString());
        }
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.cancelButton);
    }

    public void addNotify() {
        super.addNotify();
        this.getProfileNameTextField().requestFocus();
    }

    protected JPanel getMainPanel() {
        if (this.mainPanel == null) {
            JLabel jLabel;
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new GridBagLayout());
            this.mainPanel.setPreferredSize(new Dimension(300, 180));
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            String string = new LString("connection_info.profile.label", "Profile").getString();
            String string2 = new LString("connection_info.hostname.label", "Hostname").getString();
            String string3 = new LString("connection_info.username.label", "Username").getString();
            boolean bl2 = false;
            int n2 = this.getFont().getSize();
            while (!bl2 && n2 >= 8) {
                jLabel = new JLabel("");
                this.setFont(new Font(jLabel.getFont().getFontName(), jLabel.getFont().getStyle(), n2));
                fontMetrics = this.getFontMetrics(this.getFont());
                int n3 = fontMetrics.stringWidth(string);
                int n4 = fontMetrics.stringWidth(string2);
                int n5 = fontMetrics.stringWidth(string3);
                if (n4 < 102 && n5 < 102 && n3 < 102) {
                    bl2 = true;
                }
                --n2;
            }
            jLabel = new JLabel("  " + string + ":");
            jLabel.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel, this.getGBC(0, 16, 0.3, 1.0, 0, 0, 1, 2));
            this.mainPanel.add((Component)this.getProfileNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 1, 4, 1));
            JLabel jLabel2 = new JLabel("  " + string2 + ":");
            jLabel2.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel2, this.getGBC(0, 16, 0.3, 1.0, 0, 2, 1, 2));
            this.mainPanel.add((Component)this.getHostNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 3, 4, 1));
            JLabel jLabel3 = new JLabel("  " + string3 + ":");
            jLabel3.setFont(this.getFont());
            this.mainPanel.add((Component)jLabel3, this.getGBC(0, 16, 0.3, 1.0, 0, 4, 1, 2));
            this.mainPanel.add((Component)this.getUserNameTextField(), this.getGBC(0, 16, 0.7, 0.0, 1, 5, 4, 1));
            this.mainPanel.add((Component)this.getAnonCheckBox(), this.getGBC(0, 17, 0.3, 1.0, 1, 6, 1, 1));
        }
        if (!System.getProperty("java.version").startsWith("1.2")) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AddBookmarkDialog.this.getProfileNameTextField().requestFocus();
                    AddBookmarkDialog.this.setResizable(false);
                }
            });
        }
        return this.mainPanel;
    }

    protected JTextField getProfileNameTextField() {
        if (this.profileNameTextField == null) {
            this.profileNameTextField = new JTextField(15);
            this.unSetEnterEvent(this.profileNameTextField);
        }
        return this.profileNameTextField;
    }
}

