/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.gui;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.gui.ImageCanvas;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.gui.Strength;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AboutBox
extends JDialog
implements Constants {
    private SecureFtpApplet parent;
    private JPanel buttonPanel = null;
    private JPanel imagePanel = null;
    private JPanel infoPanel = null;
    private GridBagConstraints gbc = new GridBagConstraints();

    public AboutBox(SecureFtpApplet secureFtpApplet) {
        super(JOptionPane.getRootFrame(), "Secure FTP v. 1.6.3 " + Strength.getStrength(), true);
        this.parent = secureFtpApplet;
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getImagePanel(), "North");
        this.getContentPane().add((Component)this.getInfoPanel(), "Center");
        this.getContentPane().add(Box.createHorizontalStrut(10), "West");
        this.getImagePanel().setPreferredSize(new Dimension(450, 235));
        this.getInfoPanel().setPreferredSize(new Dimension(450, 200));
        this.getContentPane().setBackground(Color.white);
        this.getImagePanel().setBackground(Color.white);
        this.getInfoPanel().setBackground(Color.white);
        this.pack();
        if (System.getProperty("java.version").startsWith("1.2")) {
            this.addKeyListeners();
            this.addMouseListeners();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AboutBox.this.addKeyListeners();
                    AboutBox.this.addMouseListeners();
                    AboutBox.this.setResizable(false);
                }
            });
        }
        this.setLocationRelativeTo(this.parent.getContentPane());
        ((Component)this).setVisible(true);
    }

    private void addKeyListeners() {
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                AboutBox.this.dispose();
            }
        });
    }

    private void addMouseListeners() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                AboutBox.this.dispose();
            }
        });
    }

    private JLabel getAdvisorLabel() {
        String string = "Advised by Sid Karin and Tom Perrine";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 12));
        return jLabel;
    }

    private JLabel getAuthorLabel() {
        String string = "Written by Gary Cohen and Brian Knight";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 12));
        return jLabel;
    }

    private JLabel getBlanketLabel() {
        String string = "All content used or mentioned herein belongs to its respective owners.";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 9));
        return jLabel;
    }

    private JLabel getCopyrightLabel() {
        JLabel jLabel = new JLabel("\u00a9 2000-03 San Diego Supercomputer Center / Glub Tech");
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    protected GridBagConstraints getGBC(int n2, int n3, double d10, double d11, int n4, int n5, int n6, int n7) {
        this.gbc.fill = n2;
        this.gbc.anchor = n3;
        this.gbc.weightx = d10;
        this.gbc.weighty = d11;
        this.gbc.gridx = n4;
        this.gbc.gridy = n5;
        this.gbc.gridwidth = n6;
        this.gbc.gridheight = n7;
        return this.gbc;
    }

    private JPanel getImagePanel() {
        if (this.imagePanel == null) {
            this.imagePanel = new JPanel();
            Image image = Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("images/logo.jpg"));
            ImageCanvas imageCanvas = new ImageCanvas(image);
            imageCanvas.setBackground(Color.white);
            this.imagePanel.add(imageCanvas);
        }
        return this.imagePanel;
    }

    private JPanel getInfoPanel() {
        if (this.infoPanel == null) {
            int n2 = 0;
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new GridBagLayout());
            this.infoPanel.add(Box.createVerticalStrut(10), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)new JLabel("Secure FTP v. 1.6.3 " + Strength.getStrength()), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add(Box.createVerticalStrut(10), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getAuthorLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getAdvisorLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getLocalizationLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getQALabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getSpecialThanksLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getSSLLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getPhotoDiscLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add(Box.createVerticalStrut(5), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getBlanketLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getURLLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
            this.infoPanel.add((Component)this.getCopyrightLabel(), this.getGBC(0, 17, 1.0, 1.0, 0, n2++, 1, 1));
        }
        return this.infoPanel;
    }

    private JLabel getLocalizationLabel() {
        String string = "Localized by Nat Haga, Giovanni Chierico, Sylvie Barchechath, Franc Apel, & Lidia Sheinin";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    private JLabel getPhotoDiscLabel() {
        String string = "Graphic licensed from PhotoDisc.";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 9));
        return jLabel;
    }

    private JLabel getQALabel() {
        String string = "Quality Assurance by Brian Crain";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    private JLabel getSSLLabel() {
        String string = "Secure Socket Layer implementation (JSSE) provided by Sun Microsystems.";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 9));
        return jLabel;
    }

    private JLabel getSpecialThanksLabel() {
        String string = "Special thanks to Wayne Schroeder, Marlene Willis, and Gunter Koch";
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }

    private JLabel getURLLabel() {
        JLabel jLabel = new JLabel("http://secureftp.sdsc.edu | http://secureftp.glub.com");
        jLabel.setFont(new Font("Dialog", 0, 10));
        return jLabel;
    }
}

