/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.Constants;
import edu.sdsc.secureftp.data.XMLParser;
import edu.sdsc.secureftp.debug;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;

public class Preferences
implements Constants {
    String file;
    Hashtable prefs;

    public Preferences(String string) {
        this.file = string;
        this.prefs = new Hashtable();
    }

    public int getHeight() {
        try {
            return Integer.parseInt((String)this.prefs.get("height"));
        }
        catch (Exception exception) {
            return 500;
        }
    }

    public String getHttpProxyHost() {
        return (String)this.prefs.get("http_proxy_host");
    }

    public String getHttpProxyPort() {
        return (String)this.prefs.get("http_proxy_port");
    }

    public int getInternalHeight() {
        try {
            return Integer.parseInt((String)this.prefs.get("internal_height"));
        }
        catch (Exception exception) {
            return this.getHeight() - 100;
        }
    }

    public int getInternalWidth() {
        try {
            return Integer.parseInt((String)this.prefs.get("internal_width"));
        }
        catch (Exception exception) {
            return this.getWidth() / 2 - 10;
        }
    }

    public String getSocksProxyHost() {
        return (String)this.prefs.get("socks_proxy_host");
    }

    public String getSocksProxyPort() {
        return (String)this.prefs.get("socks_proxy_port");
    }

    public Color getThemeColor() {
        try {
            return new Color(Integer.parseInt((String)this.prefs.get("theme_color")));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getThemeIndex() {
        try {
            return Integer.parseInt((String)this.prefs.get("theme_index"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getTransferMode() {
        try {
            return Integer.parseInt((String)this.prefs.get("transfer_mode"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getWidth() {
        try {
            return Integer.parseInt((String)this.prefs.get("width"));
        }
        catch (Exception exception) {
            return 625;
        }
    }

    public void readPreferences() throws Exception {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            debug.println("preferences file does not exist, using defaults");
            return;
        }
        this.prefs = XMLParser.parse(bufferedReader, "preferences");
        bufferedReader.close();
    }

    public void setHeight(int n2) {
        this.prefs.put("height", Integer.toString(n2));
    }

    public void setHttpProxyHost(String string) {
        this.prefs.put("http_proxy_host", string);
    }

    public void setHttpProxyPort(String string) {
        this.prefs.put("http_proxy_port", string);
    }

    public void setInternalHeight(int n2) {
        this.prefs.put("internal_height", Integer.toString(n2));
    }

    public void setInternalWidth(int n2) {
        this.prefs.put("internal_width", Integer.toString(n2));
    }

    public void setSocksProxyHost(String string) {
        this.prefs.put("socks_proxy_host", string);
    }

    public void setSocksProxyPort(String string) {
        this.prefs.put("socks_proxy_port", string);
    }

    public void setThemeColor(Color color) {
        this.prefs.put("theme_color", Integer.toString(color.getRGB()));
    }

    public void setThemeIndex(int n2) {
        this.prefs.put("theme_index", Integer.toString(n2));
    }

    public void setTransferMode(int n2) {
        this.prefs.put("transfer_mode", Integer.toString(n2));
    }

    public void setWidth(int n2) {
        this.prefs.put("width", Integer.toString(n2));
    }

    public void writePreferences() throws Exception {
        PrintWriter printWriter = new PrintWriter((Writer)new FileWriter(this.file), true);
        printWriter.println("<?xml version=\"1.0\">\n\n<!-- This is a generated file.  Do not edit! -->\n\n<!DOCTYPE preferences SYSTEM \"preferences.dtd\">\n");
        printWriter.println("<preferences>");
        Enumeration enumeration = this.prefs.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            printWriter.println("  <" + k2 + ">" + this.prefs.get(k2) + "</" + k2 + ">");
        }
        printWriter.println("</preferences>\n");
        printWriter.close();
    }
}

