/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.secureftp.data;

import edu.sdsc.secureftp.data.FileEntry;
import edu.sdsc.secureftp.data.FileTypeDecider;
import edu.sdsc.secureftp.data.NotADirectoryException;
import edu.sdsc.secureftp.debug;
import edu.sdsc.secureftp.gui.ErrorDialog;
import edu.sdsc.secureftp.gui.LString;
import edu.sdsc.secureftp.gui.SecureFtpApplet;
import edu.sdsc.secureftp.network.BasicFtp;
import edu.sdsc.secureftp.network.exception.FtpConnectionLostException;
import edu.sdsc.secureftp.network.exception.FtpException;
import edu.sdsc.secureftp.network.exception.FtpNoSuchFileException;
import edu.sdsc.secureftp.network.exception.FtpNotADirectoryException;
import java.io.File;
import java.util.Enumeration;

public abstract class FtpThread
extends Thread {
    private SecureFtpApplet gui;
    private String transferMode;
    private BasicFtp ftp;
    private String label;

    public FtpThread(SecureFtpApplet secureFtpApplet, String string) {
        this.gui = secureFtpApplet;
        this.transferMode = string;
        this.ftp = this.gui.getFtpNet();
        this.label = " ";
    }

    public abstract boolean changeDestDir(String var1) throws NotADirectoryException;

    protected boolean changeFtpDir(String string) throws NotADirectoryException {
        boolean bl2 = true;
        try {
            this.ftp.chdir(string);
        }
        catch (FtpNotADirectoryException ftpNotADirectoryException) {
            throw new NotADirectoryException(ftpNotADirectoryException.getMessage());
        }
        catch (FtpNoSuchFileException ftpNoSuchFileException) {
            if (!this.mkdirFtp(string)) {
                new ErrorDialog(new LString("failed_to_make_server_dir.msg", "Failed to make directory on server").getString());
                debug.println("Failed to make ftp directory: " + string);
                return false;
            }
            return this.changeFtpDir(string);
        }
        catch (FtpConnectionLostException ftpConnectionLostException) {
            return false;
        }
        catch (FtpException ftpException) {
            new ErrorDialog(new LString("failed_to_change_server_dir.msg", "Failed to change directory on server").getString());
            debug.println("Failed to change ftp directory: " + ftpException.getMessage());
            return false;
        }
        try {
            this.ftp.pwd();
            this.ftp.list();
            this.gui.getServerFrame().getDirTextField().setText(this.ftp.getDirName());
        }
        catch (FtpException ftpException) {
            new ErrorDialog(new LString("failed_to_change_server_dir.msg", "Failed to change directory on server").getString());
            debug.println("Failed to change ftp directory: " + ftpException.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    protected boolean changeLocalDir(String string) throws NotADirectoryException {
        boolean bl2 = true;
        File file = new File(string).getAbsoluteFile();
        if (!file.exists()) {
            if (!this.mkdirLocal(string)) {
                new ErrorDialog(new LString("failed_to_make_local_dir.msg", "Failed to make local directory").getString());
                debug.println("Failed to make dest directory: " + string);
                return false;
            }
            return this.changeLocalDir(string);
        }
        if (!file.isDirectory()) {
            throw new NotADirectoryException(string);
        }
        this.gui.getLocalUtil().changeDir(string);
        return bl2;
    }

    public abstract boolean changeSourceDir(String var1) throws NotADirectoryException;

    public abstract boolean doTransfer(String var1, String var2, long var3);

    public abstract String getDestDir();

    public abstract Enumeration getDirContents();

    protected String getFtpDir() {
        return this.ftp.getDirName();
    }

    public String getLabelCaption() {
        return String.valueOf(new LString("transferring_file.msg", "Transferring file").getString()) + ":";
    }

    public String getLabelText() {
        return this.label;
    }

    protected String getLocalDir() {
        return this.gui.getLocalUtil().getDirName();
    }

    public abstract String getSourceDir();

    private boolean mkdirFtp(String string) {
        boolean bl2 = true;
        try {
            this.ftp.mkdir(string);
        }
        catch (FtpException ftpException) {
            debug.println("Failed to make ftp directory: " + ftpException.getMessage());
            bl2 = false;
        }
        return bl2;
    }

    private boolean mkdirLocal(String string) {
        boolean bl2 = true;
        try {
            File file = new File(string).getAbsoluteFile();
            if (file.exists()) {
                if (!file.isDirectory()) {
                    LString lString = new LString("x_is_not_a_dir.msg", "[^0] is not a directory.");
                    lString.replace(0, file.getName());
                    new ErrorDialog(lString.getString());
                    debug.println(String.valueOf(file.getAbsolutePath()) + " is not a directory");
                    bl2 = false;
                }
            } else if (!this.gui.getLocalUtil().mkdir(file)) {
                new ErrorDialog(new LString("failed_to_make_local_dir.msg", "Failed to make local directory").getString());
                debug.println("Failed to make " + file.getAbsolutePath());
                bl2 = false;
            }
        }
        catch (Exception exception) {
            new ErrorDialog(new LString("failed_to_make_local_dir.msg", "Failed to make local directory").getString());
            debug.println("Failed to make local directory");
            bl2 = false;
        }
        return bl2;
    }

    public abstract void run();

    private void setLabelText(String string) {
        this.label = string;
    }

    public void setTransferMode(String string, String string2) {
        if (string.equals("U")) {
            FileTypeDecider fileTypeDecider = new FileTypeDecider(string2);
            string = fileTypeDecider.isTextType() ? "A" : "B";
        }
        try {
            if (string.equals("A")) {
                this.ftp.ascii(true);
            } else {
                this.ftp.binary(true);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean startTransfer(String string, String string2, long l2, char c10) {
        boolean bl2;
        block13: {
            bl2 = true;
            if (string.equals(".") || string.equals("..") || string2.equals(".") || string2.equals("..")) break block13;
            if (c10 == 'f') {
                this.setLabelText(string);
                this.ftp.getClientData().startFileTransfer(l2);
                this.setTransferMode(this.transferMode, string);
                bl2 = this.doTransfer(string, string2, l2);
            } else {
                String string3 = this.getDestDir();
                String string4 = this.getSourceDir();
                try {
                    if (!this.changeSourceDir(string)) {
                        return false;
                    }
                }
                catch (NotADirectoryException notADirectoryException) {
                    return this.startTransfer(string, string2, l2, 'f');
                }
                try {
                    if (!this.changeDestDir(string2)) {
                        bl2 = false;
                    }
                }
                catch (NotADirectoryException notADirectoryException) {
                    new ErrorDialog(new LString("failed_to_change_dest_dir.msg", "Failed to change destination directory").getString());
                    debug.println("Cannot change to dest dir: " + notADirectoryException.getMessage());
                    return false;
                }
                Enumeration enumeration = this.getDirContents();
                while (bl2 && enumeration.hasMoreElements()) {
                    FileEntry fileEntry = (FileEntry)enumeration.nextElement();
                    String string5 = fileEntry.getName();
                    if (string5.equals(".") || string5.equals("..")) continue;
                    bl2 = this.startTransfer(string5, string5, fileEntry.getSize(), fileEntry.getType());
                }
                try {
                    this.changeDestDir(string3);
                }
                catch (NotADirectoryException notADirectoryException) {
                    new ErrorDialog(new LString("failed_to_change_dest_dir.msg", "Failed to change destination directory").getString());
                    debug.println("Cannot change to dest dir: " + notADirectoryException.getMessage());
                }
                try {
                    this.changeSourceDir(string4);
                }
                catch (NotADirectoryException notADirectoryException) {
                    new ErrorDialog(new LString("failed_to_change_source_dir.msg", "Failed to change source directory").getString());
                    debug.println("Cannot change to source dir: " + notADirectoryException.getMessage());
                }
            }
        }
        return bl2;
    }
}

