/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Block;
import com.sun.java.help.search.BlockFactory;
import com.sun.java.help.search.BlockManagerParameters;
import com.sun.java.help.search.BlockProcessor;
import com.sun.java.help.search.RAFFile;
import com.sun.java.help.search.RAFFileFactory;
import java.io.IOException;

class BlockManager {
    private static RAFFileFactory factory = RAFFileFactory.create();
    private RAFFile file;
    private long blockSize;
    private boolean update;
    private final int nBlocksLimit = 64;
    private int blockTableSize;
    private BlockDescriptor[] blockTab;
    private int nBlocks = 0;
    private int oldest = 0;
    private int newest = 0;
    private BlockFactory bfactory = null;
    private static final int INCR = 256;
    private Block dummy;
    private boolean debug = false;

    public BlockManager(BlockManagerParameters blockManagerParameters, boolean bl2, BlockFactory blockFactory) throws IOException {
        this.bfactory = blockFactory;
        this.update = bl2;
        this.blockSize = blockManagerParameters.getBlockSize();
        this.debug(blockManagerParameters.getURL().toString());
        this.file = factory.get(blockManagerParameters.getURL(), bl2);
        this.debug(this.file.toString());
        this.dummy = blockFactory.makeBlock();
        if (this.file.length() == 0L && bl2) {
            this.dummy.setBlockNumber(0);
            this.writeBlock(this.dummy);
        }
        this.blockTableSize = (int)(this.file.length() / this.blockSize);
        this.blockTab = new BlockDescriptor[this.blockTableSize];
        this.mapBlock(0, new BlockDescriptor(), blockFactory.makeBlock());
    }

    public Block accessBlock(int n2) throws Exception {
        if (this.blockTab[n2] != null) {
            this.moveToFront(n2);
        } else if (this.nBlocks < 64) {
            this.mapBlock(n2, new BlockDescriptor(), this.bfactory.makeBlock());
        } else {
            this.remapSomeBlock(n2);
        }
        return this.blockTab[n2].block;
    }

    private void addDescriptor(Block block, int n2, BlockDescriptor blockDescriptor) {
        this.blockTab[n2] = blockDescriptor;
        blockDescriptor.block = block;
        blockDescriptor.prev = this.newest;
        this.blockTab[this.newest].next = n2;
        this.newest = n2;
        ++this.nBlocks;
    }

    public void close() throws IOException {
        if (this.update) {
            int n2 = 0;
            while (n2 < this.blockTableSize) {
                if (this.blockTab[n2] != null && this.blockTab[n2].modf) {
                    this.writeBlock(this.blockTab[n2].block);
                }
                ++n2;
            }
        }
        this.file.close();
    }

    private void debug(String string) {
        if (this.debug) {
            System.err.println("Block Manager: " + string);
        }
    }

    public Block getNewBlock() throws Exception {
        Object object;
        int n2 = (int)(this.file.length() / this.blockSize);
        if (n2 > this.blockTableSize - 1) {
            object = new BlockDescriptor[this.blockTableSize + 256];
            System.arraycopy(this.blockTab, 0, object, 0, this.blockTableSize);
            this.blockTab = object;
            this.blockTableSize += 256;
        }
        if (this.nBlocks < 64) {
            object = this.bfactory.makeBlock();
            ((Block)object).setBlockNumber(n2);
            this.writeBlock((Block)object);
            this.addDescriptor((Block)object, n2, new BlockDescriptor());
        } else {
            this.dummy.setBlockNumber(n2);
            this.writeBlock(this.dummy);
            this.remapSomeBlock(n2);
        }
        return this.blockTab[n2].block;
    }

    public void lockBlock(int n2) {
        this.blockTab[n2].lock = true;
    }

    private void mapBlock(int n2, BlockDescriptor blockDescriptor, Block block) throws IOException {
        this.file.seek(this.blockSize * (long)n2);
        Block.readIn(this.file, block);
        this.addDescriptor(block, n2, blockDescriptor);
    }

    public void mapBlocks(BlockProcessor blockProcessor) throws IOException {
        long l2 = this.file.length() / this.blockSize;
        Block block = this.bfactory.makeBlock();
        this.file.seek(0L);
        int n2 = 0;
        while ((long)n2 < l2) {
            blockProcessor.process(Block.readIn(this.file, block));
            ++n2;
        }
    }

    private void moveToFront(int n2) {
        if (n2 == this.oldest) {
            this.oldest = this.blockTab[n2].next;
            this.blockTab[n2].prev = this.newest;
            this.blockTab[this.newest].next = n2;
            this.newest = n2;
        } else if (n2 != this.newest) {
            this.blockTab[this.blockTab[n2].next].prev = this.blockTab[n2].prev;
            this.blockTab[this.blockTab[n2].prev].next = this.blockTab[n2].next;
            this.blockTab[n2].prev = this.newest;
            this.blockTab[this.newest].next = n2;
            this.newest = n2;
        }
    }

    private void remapSomeBlock(int n2) throws Exception {
        int n3 = this.oldest;
        while (this.blockTab[n3].lock && n3 != this.newest) {
            n3 = this.blockTab[n3].next;
        }
        if (this.blockTab[n3].lock) {
            throw new Exception("everything locked");
        }
        if (this.blockTab[n3].modf) {
            this.writeBlock(this.blockTab[n3].block);
        }
        --this.nBlocks;
        Block block = this.blockTab[n3].block;
        if (n3 == this.oldest) {
            this.oldest = this.blockTab[n3].next;
        } else if (n3 == this.newest) {
            this.newest = this.blockTab[n3].prev;
        } else {
            this.blockTab[this.blockTab[n3].next].prev = this.blockTab[n3].prev;
            this.blockTab[this.blockTab[n3].prev].next = this.blockTab[n3].next;
        }
        this.blockTab[n3].reset();
        this.mapBlock(n2, this.blockTab[n3], block);
        this.blockTab[n3] = null;
    }

    public void setModified(int n2) {
        this.blockTab[n2].modf = true;
    }

    public void unlockBlock(int n2) {
        this.blockTab[n2].lock = false;
    }

    public void writeBlock(Block block) throws IOException {
        this.file.seek(this.blockSize * (long)block.number);
        block.writeOut(this.file);
    }

    private class BlockDescriptor {
        public Block block = null;
        public boolean lock = false;
        public boolean modf = false;
        public int prev = 0;
        public int next = 0;

        BlockDescriptor() {
        }

        public void reset() {
            this.modf = false;
            this.lock = false;
            this.block = null;
        }
    }
}

