/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.zip;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ZipWriter
implements Serializable {
    private static final int _BUFFER = 2048;
    private ByteArrayOutputStream _baos;
    private ZipOutputStream _zos;
    private byte[] _data;

    public void addEntry(String name, StringBuffer sb) throws IOException {
        this.addEntry(name, sb.toString());
    }

    public void addEntry(String name, String s) throws IOException {
        this.addEntry(name, s.getBytes());
    }

    public void addEntry(String name, byte[] byteArray) throws IOException {
        int count;
        ZipEntry entry = new ZipEntry(name);
        this._zos.putNextEntry(entry);
        BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(byteArray), 2048);
        while ((count = bis.read(this._data, 0, 2048)) != -1) {
            this._zos.write(this._data, 0, count);
        }
        bis.close();
    }

    public byte[] finish() throws IOException {
        this._zos.close();
        return this._baos.toByteArray();
    }

    private final /* synthetic */ void this() {
        this._data = new byte[2048];
    }

    public ZipWriter() {
        this.this();
        this._baos = new ByteArrayOutputStream();
        this._zos = new ZipOutputStream(new BufferedOutputStream(this._baos));
    }
}

