/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.xml;

import com.liferay.util.xml.ElementComparator;
import com.liferay.util.xml.XMLElementComparator;
import com.liferay.util.xml.descriptor.XMLDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLMerger {
    private XMLDescriptor _descriptor;

    public XMLElementComparator getElementComparator() {
        return new XMLElementComparator(this._descriptor);
    }

    public Document merge(Document masterDoc, Document slaveDoc) {
        Document mergedDoc = (Document)masterDoc.clone();
        Element root1 = mergedDoc.getRootElement();
        Element root2 = slaveDoc.getRootElement();
        List children = root2.elements();
        int i = 0;
        while (i < children.size()) {
            Element el2 = (Element)children.get(i);
            Element el2Clone = (Element)el2.clone();
            el2Clone.detach();
            root1.add(el2Clone);
            ++i;
        }
        this.organizeXML(mergedDoc);
        return mergedDoc;
    }

    public void organizeXML(Document doc) {
        Element root = doc.getRootElement();
        this._orderChildren(root, this._descriptor.getRootChildrenOrder());
        this._mergeDuplicateElements(root, this.getElementComparator());
    }

    private final void _addChildren(Element first, Collection childrenToJoin) {
        Vector<Object> clones = new Vector<Object>();
        Iterator itr = childrenToJoin.iterator();
        while (itr.hasNext()) {
            clones.add(((Element)itr.next()).clone());
        }
        first.elements().addAll(clones);
    }

    private final boolean _containsObjectEqualTo(Element example, List list, ElementComparator comparator) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Element candidate = (Element)itr.next();
            if (comparator.compare(example, candidate) != 0) continue;
            return true;
        }
        return false;
    }

    private final Element _findObjectEqualTo(Element example, List list, ElementComparator comparator) {
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Element candidate = (Element)itr.next();
            if (comparator.compare(example, candidate) != 0) continue;
            return candidate;
        }
        return example;
    }

    private final void _mergeDuplicateElements(Element el, ElementComparator comparator) {
        if (el.elements().size() > 0) {
            Element child;
            List children = el.elements();
            ArrayList<Element> originals = new ArrayList<Element>();
            ArrayList<Element> duplicates = new ArrayList<Element>();
            int i = 0;
            while (i < children.size()) {
                child = (Element)children.get(i);
                if (this._containsObjectEqualTo(child, originals, comparator)) {
                    if (this._descriptor.canJoinChildren(child)) {
                        Element first = this._findObjectEqualTo(child, originals, comparator);
                        List childrenToJoin = child.elements();
                        this._addChildren(first, childrenToJoin);
                    }
                    duplicates.add(child);
                } else {
                    originals.add(child);
                }
                ++i;
            }
            i = 0;
            while (i < duplicates.size()) {
                Element duplicate = (Element)duplicates.get(i);
                duplicate.detach();
                ++i;
            }
            Iterator itr = originals.iterator();
            while (itr.hasNext()) {
                child = (Element)itr.next();
                this._mergeDuplicateElements(child, comparator);
            }
        }
    }

    private final void _orderChildren(Element parent, String[] orderedChildrenNames) {
        if (orderedChildrenNames == null) {
            return;
        }
        ArrayList elements = new ArrayList();
        int i = 0;
        while (i < orderedChildrenNames.length) {
            elements.addAll(parent.elements(orderedChildrenNames[i]));
            ++i;
        }
        i = 0;
        while (i < elements.size()) {
            Element el = (Element)elements.get(i);
            el.detach();
            parent.add(el);
            ++i;
        }
    }

    public XMLMerger(XMLDescriptor descriptor) {
        this._descriptor = descriptor;
    }
}

