/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.resin;

import com.liferay.portal.kernel.util.MethodInvoker;
import com.liferay.portal.kernel.util.MethodWrapper;
import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class BatchJspCompiler {
    private String _appDir;
    private String _classDir;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new BatchJspCompiler(args[0], args[1]);
    }

    private final void _compile(File directory) throws Exception {
        if (directory.exists() && directory.isDirectory()) {
            ArrayList<File> fileList = new ArrayList<File>();
            File[] fileArray = FileUtil.sortFiles(directory.listFiles());
            int i = 0;
            while (i < fileArray.length) {
                File file = fileArray[i];
                if (file.isDirectory()) {
                    this._compile(fileArray[i]);
                } else if (file.getName().endsWith(".jsp")) {
                    fileList.add(file);
                }
                ++i;
            }
            this._compile(directory.getPath(), fileList);
        }
    }

    private final void _compile(String sourcePath, List files) throws Exception {
        if (files.size() == 0) {
            return;
        }
        System.out.println(sourcePath);
        int i = 0;
        while (i < files.size()) {
            File file = (File)files.get(i);
            String fileName = file.toString();
            String[] args = new String[]{"-app-dir", this._appDir, "-class-dir", this._classDir, fileName};
            MethodWrapper methodWrapper = new MethodWrapper("com.caucho.jsp.JspCompiler", "main", new Object[]{args});
            try {
                MethodInvoker.invoke((MethodWrapper)methodWrapper);
            }
            catch (Exception e) {
                FileUtil.write(fileName + ".jspc_error", StackTraceUtil.getStackTrace((Throwable)e));
            }
            ++i;
        }
    }

    public BatchJspCompiler(String appDir, String classDir) {
        try {
            this._appDir = appDir;
            this._classDir = classDir;
            this._compile(new File(appDir));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

