/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.dao;

import com.liferay.util.DateUtil;
import com.liferay.util.ParamUtil;
import com.liferay.util.Validator;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import javax.portlet.PortletRequest;
import javax.servlet.ServletRequest;

public class DAOParamUtil {
    public static String getISODate(ServletRequest req, String param) {
        int month = ParamUtil.getInteger(req, param + "Month");
        int day = ParamUtil.getInteger(req, param + "Day");
        int year = ParamUtil.getInteger(req, param + "Year");
        int hour = ParamUtil.getInteger(req, param + "Hour", -1);
        int minute = ParamUtil.getInteger(req, param + "Minute", -1);
        int amPm = ParamUtil.getInteger(req, param + "AmPm");
        if (month >= 0 && day > 0 && year > 0) {
            GregorianCalendar cal = new GregorianCalendar();
            if (hour == -1 || minute == -1) {
                cal.set(year, month, day);
            } else {
                if (amPm == 1) {
                    hour += 12;
                }
                cal.set(year, month, day, hour, minute, 0);
            }
            DateFormat isoFormat = DateUtil.getISOFormat();
            return isoFormat.format(cal.getTime());
        }
        return null;
    }

    public static String getLike(ServletRequest req, String param) {
        return DAOParamUtil.getLike(req, param, null, true);
    }

    public static String getLike(ServletRequest req, String param, String defaultValue) {
        return DAOParamUtil.getLike(req, param, defaultValue, true);
    }

    public static String getLike(ServletRequest req, String param, boolean toLowerCase) {
        return DAOParamUtil.getLike(req, param, null, toLowerCase);
    }

    public static String getLike(ServletRequest req, String param, String defaultValue, boolean toLowerCase) {
        String value = req.getParameter(param);
        if (value != null) {
            value = value.trim();
            if (toLowerCase) {
                value = value.toLowerCase();
            }
        }
        value = Validator.isNull(value) ? defaultValue : "%" + value + '%';
        return value;
    }

    public static String getString(ServletRequest req, String param) {
        String value = ParamUtil.getString(req, param);
        if (Validator.isNull(value)) {
            return null;
        }
        return value;
    }

    public static String getISODate(PortletRequest req, String param) {
        int month = ParamUtil.getInteger(req, param + "Month");
        int day = ParamUtil.getInteger(req, param + "Day");
        int year = ParamUtil.getInteger(req, param + "Year");
        int hour = ParamUtil.getInteger(req, param + "Hour", -1);
        int minute = ParamUtil.getInteger(req, param + "Minute", -1);
        int amPm = ParamUtil.getInteger(req, param + "AmPm");
        if (month >= 0 && day > 0 && year > 0) {
            GregorianCalendar cal = new GregorianCalendar();
            if (hour == -1 || minute == -1) {
                cal.set(year, month, day);
            } else {
                if (amPm == 1) {
                    hour += 12;
                }
                cal.set(year, month, day, hour, minute, 0);
            }
            DateFormat isoFormat = DateUtil.getISOFormat();
            return isoFormat.format(cal.getTime());
        }
        return null;
    }

    public static String getLike(PortletRequest req, String param) {
        return DAOParamUtil.getLike(req, param, null, true);
    }

    public static String getLike(PortletRequest req, String param, String defaultValue) {
        return DAOParamUtil.getLike(req, param, defaultValue, true);
    }

    public static String getLike(PortletRequest req, String param, boolean toLowerCase) {
        return DAOParamUtil.getLike(req, param, null, toLowerCase);
    }

    public static String getLike(PortletRequest req, String param, String defaultValue, boolean toLowerCase) {
        String value = req.getParameter(param);
        if (value != null) {
            value = value.trim();
            if (toLowerCase) {
                value = value.toLowerCase();
            }
        }
        value = Validator.isNull(value) ? defaultValue : "%" + value + '%';
        return value;
    }

    public static String getString(PortletRequest req, String param) {
        String value = ParamUtil.getString(req, param);
        if (Validator.isNull(value)) {
            return null;
        }
        return value;
    }
}

