/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.SyncMap;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.liferay.util.GetterUtil;
import com.liferay.util.PropertiesUtil;
import com.liferay.util.StringUtil;
import com.liferay.util.SystemEnv;
import com.liferay.util.Validator;
import gnu.trove.THashMap;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SystemProperties {
    public static final String SYSTEM_PROPERTIES_LOAD = "system.properties.load";
    public static final String SYSTEM_PROPERTIES_FINAL = "system.properties.final";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static SystemProperties _instance = new SystemProperties();
    private Map _props;

    public static String get(String key) {
        String value = (String)SystemProperties._instance._props.get(key);
        if (value == null) {
            value = System.getProperty(key);
        }
        return value;
    }

    public static void set(String key, String value) {
        SystemProperties._instance._props.put(key, value);
    }

    public static String[] getArray(String key) {
        String value = SystemProperties.get(key);
        if (value == null) {
            return new String[0];
        }
        return StringUtil.split(value);
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(SystemProperties._instance._props);
    }

    private SystemProperties() {
        InputStream is;
        URL url;
        Properties p = new Properties();
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            url = classLoader.getResource("system.properties");
            if (url != null) {
                is = url.openStream();
                p.load(is);
                is.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            url = classLoader.getResource("system-ext.properties");
            if (url != null) {
                is = url.openStream();
                p.load(is);
                is.close();
                System.out.println("Loading " + url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SystemEnv.setProperties(p);
        boolean systemPropertiesLoad = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_LOAD), true);
        boolean systemPropertiesFinal = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_FINAL), true);
        if (systemPropertiesLoad) {
            Enumeration<?> enu = p.propertyNames();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                if (!systemPropertiesFinal && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, (String)p.get(key));
            }
        }
        boolean useTrove = false;
        if (GetterUtil.getBoolean(System.getProperty("trove"), true)) {
            try {
                Class.forName("gnu.trove.THashMap");
            }
            catch (Exception e) {
                useTrove = false;
            }
        }
        this._props = useTrove ? new SyncMap((Map)new THashMap(), (ReadWriteLock)new WriterPreferenceReadWriteLock()) : new SyncMap(new HashMap(), (ReadWriteLock)new WriterPreferenceReadWriteLock());
        PropertiesUtil.fromProperties(p, this._props);
    }
}

