/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util;

import com.liferay.util.BeanUtil;
import com.liferay.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class ListUtil {
    public static List copy(List master) {
        if (master == null) {
            return null;
        }
        ArrayList copy = new ArrayList(master.size());
        ListUtil.copy(master, copy);
        return copy;
    }

    public static void copy(List master, List copy) {
        if (master == null || copy == null) {
            return;
        }
        copy.clear();
        Iterator itr = master.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            copy.add(obj);
        }
    }

    public static void distinct(List list) {
        ListUtil.distinct(list, null);
    }

    public static void distinct(List list, Comparator comparator) {
        if (list == null || list.size() == 0) {
            return;
        }
        TreeSet set = null;
        set = comparator == null ? new TreeSet() : new TreeSet(comparator);
        Iterator itr = list.iterator();
        while (itr.hasNext()) {
            Object obj = itr.next();
            if (set.contains(obj)) {
                itr.remove();
                continue;
            }
            set.add(obj);
        }
    }

    public static List fromArray(Object[] array) {
        if (array == null || array.length == 0) {
            return new ArrayList();
        }
        ArrayList<Object> list = new ArrayList<Object>(array.length);
        int i = 0;
        while (i < array.length) {
            list.add(array[i]);
            ++i;
        }
        return list;
    }

    public static List fromCollection(Collection c) {
        if (c != null && c instanceof List) {
            return (List)c;
        }
        if (c == null || c.size() == 0) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(c.size());
        Iterator itr = c.iterator();
        while (itr.hasNext()) {
            list.add(itr.next());
        }
        return list;
    }

    public static List fromEnumeration(Enumeration enu) {
        ArrayList list = new ArrayList();
        while (enu.hasMoreElements()) {
            Object obj = enu.nextElement();
            list.add(obj);
        }
        return list;
    }

    public static List fromFile(String fileName) throws IOException {
        return ListUtil.fromFile(new File(fileName));
    }

    public static List fromFile(File file) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(file));
        String s = "";
        while ((s = br.readLine()) != null) {
            list.add(s);
        }
        br.close();
        return list;
    }

    public static List fromString(String s) {
        return ListUtil.fromArray(StringUtil.split(s, "\n"));
    }

    public static List subList(List list, int begin, int end) {
        ArrayList newList = new ArrayList();
        int normalizedSize = list.size() - 1;
        if (begin < 0 || begin > normalizedSize || end < 0 || begin > end) {
            return newList;
        }
        int i = begin;
        while (i < end && i <= normalizedSize) {
            newList.add(list.get(i));
            ++i;
        }
        return newList;
    }

    public static String toString(List list, String param) {
        return ListUtil.toString(list, param, ",");
    }

    public static String toString(List list, String param, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            Object bean = list.get(i);
            Object value = BeanUtil.getObject(bean, param);
            if (value == null) {
                value = "";
            }
            sb.append(value.toString());
            if (i + 1 != list.size()) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }
}

