/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.Arrays;
import edu.emory.mathcs.backport.java.util.Queue;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PriorityQueue
extends AbstractQueue
implements Serializable,
Queue {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INIT_CAPACITY = 11;
    private transient Object[] buffer;
    private int size;
    private final Comparator comparator;
    private transient int modCount;
    static /* synthetic */ Class array$Ljava$lang$Object;
    private static final /* synthetic */ boolean assert;

    public Iterator iterator() {
        return new Itr();
    }

    public Comparator comparator() {
        return this.comparator;
    }

    public boolean offer(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.size == this.buffer.length) {
            int newlen = this.buffer.length * 2;
            if (newlen < this.buffer.length) {
                if (this.buffer.length == Integer.MAX_VALUE) {
                    throw new OutOfMemoryError();
                }
                newlen = Integer.MAX_VALUE;
            }
            Object[] newbuffer = new Object[newlen];
            System.arraycopy(this.buffer, 0, newbuffer, 0, this.size);
            this.buffer = newbuffer;
        }
        ++this.modCount;
        this.percolateUp(this.size++, o);
        return true;
    }

    public Object peek() {
        return this.size == 0 ? null : this.buffer[0];
    }

    public Object poll() {
        if (this.size == 0) {
            return null;
        }
        ++this.modCount;
        Object head = this.buffer[0];
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return head;
    }

    public int size() {
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int percolateDown(int idx, Object e) {
        try {
            if (this.comparator != null) {
                int c;
                while ((c = (idx << 1) + 1) < this.size) {
                    if (c + 1 < this.size && this.comparator.compare(this.buffer[c + 1], this.buffer[c]) < 0) {
                        ++c;
                    }
                    if (this.comparator.compare(e, this.buffer[c]) > 0) {
                        this.buffer[idx] = this.buffer[c];
                        idx = c;
                        continue;
                    }
                    break;
                }
            } else {
                int c;
                Comparable ec = (Comparable)e;
                while ((c = (idx << 1) + 1) < this.size) {
                    if (c + 1 < this.size && ((Comparable)this.buffer[c + 1]).compareTo(this.buffer[c]) < 0) {
                        ++c;
                    }
                    if (ec.compareTo(this.buffer[c]) > 0) {
                        this.buffer[idx] = this.buffer[c];
                        idx = c;
                        continue;
                    }
                    break;
                }
            }
            int n = idx;
            Object var4_7 = null;
            this.buffer[idx] = e;
            return n;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.buffer[idx] = e;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int percolateUp(int idx, Object e) {
        block5: {
            if (this.comparator == null) break block5;
            while (idx > 0) {
                int c = idx - 1 >>> 1;
                if (this.comparator.compare(e, this.buffer[c]) >= 0) break;
                this.buffer[idx] = this.buffer[c];
                idx = c;
            }
            int n = idx;
            Object var4_7 = null;
            this.buffer[idx] = e;
            return n;
        }
        try {
            Comparable ce = (Comparable)e;
            while (idx > 0) {
                int c = idx - 1 >>> 1;
                if (ce.compareTo(this.buffer[c]) >= 0) break;
                this.buffer[idx] = this.buffer[c];
                idx = c;
            }
            int n = idx;
            Object var4_8 = null;
            this.buffer[idx] = e;
            return n;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.buffer[idx] = e;
            throw throwable;
        }
    }

    public boolean add(Object o) {
        return this.offer(o);
    }

    public Object remove() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        Object head = this.buffer[0];
        ++this.modCount;
        --this.size;
        this.percolateDown(0, this.buffer[this.size]);
        this.buffer[this.size] = null;
        return head;
    }

    public Object element() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.buffer[0];
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size == 0) {
            bl = true;
        }
        return bl;
    }

    public boolean contains(Object o) {
        int i = 0;
        while (i < this.size) {
            if (o.equals(this.buffer[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object[] toArray() {
        Class clazz = array$Ljava$lang$Object;
        if (clazz == null) {
            clazz = array$Ljava$lang$Object = PriorityQueue.class("[Ljava.lang.Object;", true);
        }
        return Arrays.copyOf(this.buffer, this.size, clazz);
    }

    public Object[] toArray(Object[] a) {
        if (a.length < this.size) {
            return Arrays.copyOf(this.buffer, this.size, a.getClass());
        }
        System.arraycopy(this.buffer, 0, a, 0, this.size);
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    public boolean remove(Object o) {
        if (o == null) {
            return false;
        }
        if (this.comparator != null) {
            int i = 0;
            while (i < this.size) {
                if (this.comparator.compare(this.buffer[i], o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (((Comparable)this.buffer[i]).compareTo(o) == 0) {
                    this.removeAt(i);
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private final Object removeAt(int i) {
        if (!assert && i >= this.size) {
            throw new AssertionError();
        }
        ++this.modCount;
        --this.size;
        Object e = this.buffer[this.size];
        this.buffer[this.size] = null;
        int newpos = this.percolateDown(i, e);
        if (newpos != i) {
            return null;
        }
        newpos = this.percolateUp(i, e);
        return newpos < i ? e : null;
    }

    public void clear() {
        ++this.modCount;
        Arrays.fill(this.buffer, 0, this.size, null);
        this.size = 0;
    }

    private final void writeObject(ObjectOutputStream os) throws IOException {
        os.defaultWriteObject();
        os.writeInt(this.buffer.length);
        int i = 0;
        while (i < this.size) {
            os.writeObject(this.buffer[i]);
            ++i;
        }
    }

    private final void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.buffer = new Object[is.readInt()];
        int i = 0;
        while (i < this.size) {
            this.buffer[i] = is.readObject();
            ++i;
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public PriorityQueue() {
        this(11, null);
    }

    public PriorityQueue(int initialCapacity) {
        this(initialCapacity, null);
    }

    public PriorityQueue(Comparator comparator) {
        this(11, comparator);
    }

    public PriorityQueue(int initialCapacity, Comparator comparator) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException();
        }
        this.buffer = new Object[initialCapacity];
        this.comparator = comparator;
    }

    public PriorityQueue(PriorityQueue q) {
        this((Collection)q);
    }

    public PriorityQueue(SortedSet s) {
        this((Collection)s);
    }

    public PriorityQueue(Collection c) {
        int capacity = c.size();
        if ((capacity += this.size / 10) < 0) {
            capacity = Integer.MAX_VALUE;
        } else if (capacity == 0) {
            capacity = 1;
        }
        this.buffer = new Object[capacity];
        if (c instanceof PriorityQueue) {
            PriorityQueue that = (PriorityQueue)c;
            this.comparator = that.comparator;
            this.size = that.size;
            System.arraycopy(that.buffer, 0, this.buffer, 0, this.size);
        } else if (c instanceof SortedSet) {
            SortedSet s = (SortedSet)c;
            this.comparator = s.comparator();
            Iterator itr = s.iterator();
            while (itr.hasNext()) {
                this.buffer[this.size++] = itr.next();
            }
        } else {
            this.comparator = null;
            Iterator itr = c.iterator();
            while (itr.hasNext()) {
                this.buffer[this.size++] = itr.next();
            }
            int i = this.size / 2;
            while (i >= 0) {
                this.percolateDown(i, this.buffer[i]);
                --i;
            }
        }
    }

    static {
        assert = Class.forName("[Ledu.emory.mathcs.backport.java.util.PriorityQueue;").getComponentType().desiredAssertionStatus() ^ true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        int cursor;
        List percolatedElems;
        int cursorPercolated;
        int expectedModCount;
        int lastRet;
        Object lastRetPercolated;

        public boolean hasNext() {
            boolean bl = false;
            if (this.cursor < PriorityQueue.this.size || this.percolatedElems != null) {
                bl = true;
            }
            return bl;
        }

        public Object next() {
            this.checkForComodification();
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.buffer[this.lastRet];
            }
            if (this.percolatedElems != null) {
                this.lastRet = -1;
                this.lastRetPercolated = this.percolatedElems.remove(this.percolatedElems.size() - 1);
                if (this.percolatedElems.isEmpty()) {
                    this.percolatedElems = null;
                }
                return this.lastRetPercolated;
            }
            throw new NoSuchElementException();
        }

        public void remove() {
            if (this.lastRet >= 0) {
                Object percolatedElem = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (percolatedElem == null) {
                    --this.cursor;
                } else {
                    if (this.percolatedElems == null) {
                        this.percolatedElems = new ArrayList();
                    }
                    this.percolatedElems.add(percolatedElem);
                }
            } else if (this.lastRetPercolated != null) {
                PriorityQueue.this.remove(this.lastRetPercolated);
                this.lastRetPercolated = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        private final void checkForComodification() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final /* synthetic */ void this() {
            this.cursor = 0;
            this.cursorPercolated = 0;
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        Itr() {
            this.this();
        }
    }
}

