/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.uadetector.VersionNumber;

public final class VersionParser {
    private static final Pattern VERSIONNUMBER = Pattern.compile("((\\d+)((\\.\\d+)+)?)");
    private static final Pattern VERSIONNUMBER_WITH_SUFFIX = Pattern.compile(VERSIONNUMBER.pattern() + "((\\s|\\-|\\.|\\[|\\]|\\w+)+)?");
    private static final Pattern VERSIONSTRING = Pattern.compile("^" + VERSIONNUMBER_WITH_SUFFIX.pattern());

    public static VersionNumber parseLastVersionNumber(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Argument 'text' must not be null.");
        }
        Matcher matcher = VERSIONNUMBER_WITH_SUFFIX.matcher(text);
        String[] split = null;
        String ext = null;
        while (matcher.find()) {
            split = matcher.group(1).split("\\.");
            ext = matcher.group(5);
        }
        String extension = ext == null ? "" : VersionParser.trimRight(ext);
        return split == null ? VersionNumber.UNKNOWN : new VersionNumber(Arrays.asList(split), extension);
    }

    public static VersionNumber parseVersion(String version) {
        if (version == null) {
            throw new IllegalArgumentException("Argument 'version' must not be null.");
        }
        VersionNumber result = new VersionNumber(new ArrayList<String>(0), version);
        Matcher matcher = VERSIONSTRING.matcher(version);
        if (matcher.find()) {
            List<String> groups = Arrays.asList(matcher.group(1).split("\\."));
            String extension = matcher.group(5) == null ? "" : VersionParser.trimRight(matcher.group(5));
            result = new VersionNumber(groups, extension);
        }
        return result;
    }

    private static String trimRight(String text) {
        return text.replaceAll("\\s+$", "");
    }

    private VersionParser() {
    }
}

