/*
 * Decompiled with CFR 0.152.
 */
package net.sf.uadetector.internal.data.domain;

public final class BrowserOperatingSystemMapping {
    private final int browserId;
    private final int operatingSystemId;

    public BrowserOperatingSystemMapping(int browserId, int operatingSystemId) {
        if (browserId < 0) {
            throw new IllegalArgumentException("Argument 'browserId' can not be smaller than 0.");
        }
        if (operatingSystemId < 0) {
            throw new IllegalArgumentException("Argument 'operatingSystemId' can not be smaller than 0.");
        }
        this.browserId = browserId;
        this.operatingSystemId = operatingSystemId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BrowserOperatingSystemMapping other = (BrowserOperatingSystemMapping)obj;
        if (this.browserId != other.browserId) {
            return false;
        }
        return this.operatingSystemId == other.operatingSystemId;
    }

    public int getBrowserId() {
        return this.browserId;
    }

    public int getOperatingSystemId() {
        return this.operatingSystemId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.browserId;
        result = 31 * result + this.operatingSystemId;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BrowserOperatingSystemMapping [browserId=");
        builder.append(this.browserId);
        builder.append(", operatingSystemId=");
        builder.append(this.operatingSystemId);
        builder.append("]");
        return builder.toString();
    }

    public static final class Builder {
        private int browserId;
        private int operatingSystemId;

        public BrowserOperatingSystemMapping build() {
            return new BrowserOperatingSystemMapping(this.browserId, this.operatingSystemId);
        }

        public int getBrowserId() {
            return this.browserId;
        }

        public int getOperatingSystemId() {
            return this.operatingSystemId;
        }

        public Builder setBrowserId(int browserId) {
            if (browserId < 0) {
                throw new IllegalArgumentException("Argument 'browserId' can not be smaller than 0.");
            }
            this.browserId = browserId;
            return this;
        }

        public Builder setBrowserId(String browserId) {
            if (browserId == null) {
                throw new IllegalArgumentException("Argument 'browserId' must not be null.");
            }
            this.setBrowserId(Integer.parseInt(browserId));
            return this;
        }

        public Builder setOperatingSystemId(int operatingSystemId) {
            if (operatingSystemId < 0) {
                throw new IllegalArgumentException("Argument 'operatingSystemId' can not be smaller than 0.");
            }
            this.operatingSystemId = operatingSystemId;
            return this;
        }

        public Builder setOperatingSystemId(String operatingSystemId) {
            if (operatingSystemId == null) {
                throw new IllegalArgumentException("Argument 'operatingSystemId' must not be null.");
            }
            this.setOperatingSystemId(Integer.parseInt(operatingSystemId));
            return this;
        }
    }
}

